/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.block;

import de.cristelknight.doapi.common.registry.DoApiSoundEventRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.satisfy.candlelight.entity.StoveBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoveBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;

    public StoveBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity entity = world.m_7702_(pos);
        if (entity instanceof MenuProvider) {
            MenuProvider factory = (MenuProvider)entity;
            player.m_5893_(factory);
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.m_60713_(newState.m_60734_())) {
            return;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof StoveBlockEntity) {
            StoveBlockEntity entity = (StoveBlockEntity)blockEntity;
            if (world instanceof ServerLevel) {
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)entity);
                entity.dropExperience((ServerLevel)world, Vec3.m_82512_((Vec3i)pos));
            }
            world.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, world, pos, newState, moved);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, LIT});
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        if (!world.f_46443_) {
            return (lvl, pos, blkState, t) -> {
                if (t instanceof StoveBlockEntity) {
                    StoveBlockEntity stoveBlock = (StoveBlockEntity)t;
                    stoveBlock.tick(lvl, pos, blkState, stoveBlock);
                }
            };
        }
        return null;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new StoveBlockEntity(pos, state);
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.m_61143_((Property)LIT)).booleanValue() || !world.m_46859_(pos.m_7494_())) {
            return;
        }
        double d = (double)pos.m_123341_() + 0.5;
        double e = (double)pos.m_123342_() + 0.24;
        double f = (double)pos.m_123343_() + 0.5;
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        double h = random.m_188500_() * 0.6 - 0.3;
        double i = direction.m_122434_() == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : h;
        double j = random.m_188500_() * 6.0 / 16.0;
        double k = direction.m_122434_() == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : h;
        world.m_7785_(d, e, f, (SoundEvent)DoApiSoundEventRegistry.STOVE_CRACKLING.get(), SoundSource.BLOCKS, 0.05f, 1.0f, false);
        for (int l = 0; l < 2; ++l) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d + i, e + j, f + k, 0.0, 0.0, 0.0);
            world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d + i, e + j, f + k, 0.0, 0.0, 0.0);
        }
    }

    public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entity) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue() && entity instanceof Player && !EnchantmentHelper.m_44938_((LivingEntity)((Player)entity))) {
            entity.m_6469_(world.m_269111_().m_269047_(), 1.0f);
        }
    }
}

