/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.util;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.satisfy.brewery.block.entity.rope.RopeKnotEntity;
import net.satisfy.brewery.util.rope.RopeConnection;

public class BreweryMath {
    public static int getRandomHighNumber(RandomSource rnd, int lowerBound, int upperBound) {
        int range = upperBound - lowerBound + 1;
        return upperBound - (int)(Math.pow(rnd.m_188500_(), 1.5) * (double)range);
    }

    public static BlockPos ofFloored(Vec3 vec) {
        return BreweryMath.ofFloored(vec.m_7096_(), vec.m_7098_(), vec.m_7094_());
    }

    public static BlockPos ofFloored(double x, double y, double z) {
        return new BlockPos(Mth.m_14107_((double)x), Mth.m_14107_((double)y), Mth.m_14107_((double)z));
    }

    public static Set<BlockPos> lineIntersection(RopeConnection connection) {
        Entity entity = connection.to();
        if (entity instanceof RopeKnotEntity) {
            RopeKnotEntity toKnot = (RopeKnotEntity)entity;
            BlockPos start = connection.from().m_31748_();
            BlockPos end = toKnot.m_31748_();
            return BreweryMath.lineIntersection(start.m_123341_(), start.m_123342_(), start.m_123343_(), end.m_123341_(), end.m_123342_(), end.m_123343_());
        }
        return new HashSet<BlockPos>();
    }

    private static Set<BlockPos> lineIntersection(int startX, int startY, int startZ, int endX, int endY, int endZ) {
        HashSet<BlockPos> blockPositions = new HashSet<BlockPos>();
        if (endX - startX == 0 && endZ - startZ == 0) {
            return blockPositions;
        }
        boolean switchX = false;
        if (startX > endX) {
            int temp = startX;
            startX = endX;
            endX = temp;
            switchX = true;
        }
        boolean switchY = false;
        if (startY > endY) {
            int temp = startY;
            startY = endY;
            endY = temp;
            switchY = true;
        }
        boolean switchZ = false;
        if (startZ > endZ) {
            int temp = startZ;
            startZ = endZ;
            endZ = temp;
            switchZ = true;
        }
        int dx = endX - startX;
        int dy = endY - startY;
        int dz = endZ - startZ;
        int gcd = BreweryMath.gcd(BreweryMath.gcd(dx, dy), dz);
        if (gcd == 0) {
            return blockPositions;
        }
        for (int t = 1; t < gcd; ++t) {
            int x = switchX ? endX - dx * t / gcd : startX + dx * t / gcd;
            int y = switchY ? endY - dy * t / gcd : startY + dy * t / gcd;
            int z = switchZ ? endZ - dz * t / gcd : startZ + dz * t / gcd;
            blockPositions.add(new BlockPos(x, y, z));
        }
        return blockPositions;
    }

    public static int gcd(int a, int b) {
        if (b == 0) {
            return a;
        }
        return BreweryMath.gcd(b, a % b);
    }

    public static Vec3 middleOf(Vec3 a, Vec3 b) {
        double x = (a.m_7096_() - b.m_7096_()) / 2.0 + b.m_7096_();
        double y = (a.m_7098_() - b.m_7098_()) / 2.0 + b.m_7098_();
        double z = (a.m_7094_() - b.m_7094_()) / 2.0 + b.m_7094_();
        return new Vec3(x, y, z);
    }
}

