/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.satisfy.brewery.block.entity.rope.HangingRopeEntity;
import net.satisfy.brewery.client.render.RopeRender;
import net.satisfy.brewery.registry.EntityRegistry;
import net.satisfy.brewery.util.BreweryIdentifier;
import net.satisfy.brewery.util.BreweryMath;

@OnlyIn(value=Dist.CLIENT)
public class HangingRopeRenderer
extends EntityRenderer<HangingRopeEntity> {
    private final RopeRender hopRopeRenderer = new RopeRender();

    public HangingRopeRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public boolean shouldRender(HangingRopeEntity entity, Frustum frustum, double d, double e, double f) {
        if (!entity.m_6000_(d, e, f)) {
            return false;
        }
        if (super.m_5523_((Entity)entity, frustum, d, e, f)) {
            return true;
        }
        Vec3 bottomPos = entity.m_20182_().m_82549_(entity.getRopeVec());
        AABB aABB = new AABB(bottomPos.m_7096_() - 2.0, bottomPos.m_7098_() - 2.0, bottomPos.m_7098_() - 2.0, bottomPos.m_7096_() + 2.0, bottomPos.m_7098_() + 2.0, bottomPos.m_7094_() + 2.0);
        return frustum.m_113029_(aABB);
    }

    public void render(HangingRopeEntity entity, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        super.m_7392_((Entity)entity, f, g, poseStack, multiBufferSource, i);
        if (!entity.active()) {
            return;
        }
        RenderType entityCutout = RenderType.m_110458_((ResourceLocation)new BreweryIdentifier("textures/rope/rope.png"));
        Vec3 ropeVec = entity.getRopeVec();
        if (ropeVec.m_82553_() < 1.0) {
            return;
        }
        BlockPos blockPosOfStart = BreweryMath.ofFloored(entity.m_20182_());
        BlockPos blockPosOfEnd = BreweryMath.ofFloored(entity.m_20182_().m_82549_(ropeVec).m_82549_(new Vec3(0.0, 1.0, 0.0)));
        Level level = entity.m_9236_();
        int blockLightLevelOfStart = level.m_45517_(LightLayer.BLOCK, blockPosOfStart);
        int blockLightLevelOfEnd = level.m_45517_(LightLayer.BLOCK, blockPosOfEnd);
        int skylightLevelOfStart = level.m_45517_(LightLayer.SKY, blockPosOfStart);
        int skylightLevelOfEnd = level.m_45517_(LightLayer.SKY, blockPosOfEnd);
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(entityCutout);
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, ((EntityType)EntityRegistry.HANGING_ROPE.get()).m_20679_(), 0.0f);
        this.hopRopeRenderer.render(vertexConsumer, poseStack, ropeVec, entity.m_19879_(), blockLightLevelOfStart, blockLightLevelOfEnd, skylightLevelOfStart, skylightLevelOfEnd);
        poseStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(HangingRopeEntity entity) {
        return null;
    }
}

