/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.block;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.brewery.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HangingRope
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty TOP = BooleanProperty.m_61465_((String)"top");
    private static final VoxelShape SHAPE = Block.m_49796_((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)16.0, (double)9.5);

    public HangingRope(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)TOP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public static void tryLowerRope(ServerLevel serverLevel, BlockPos blockPos) {
        BlockPos belowPos = blockPos.m_7495_();
        if (HangingRope.canLower(serverLevel.m_8055_(belowPos))) {
            HangingRope.lowerRope(serverLevel, belowPos);
        }
    }

    private static boolean canLower(BlockState blockState) {
        return blockState.m_60795_();
    }

    private static void lowerRope(ServerLevel serverLevel, BlockPos blockPos) {
        serverLevel.m_7731_(blockPos, ((Block)ObjectRegistry.HANGING_ROPE.get()).m_49966_(), 3);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        FluidState fluidState = blockPlaceContext.m_43725_().m_6425_(blockPlaceContext.m_8083_());
        boolean bl = fluidState.m_76152_() == Fluids.f_76193_;
        return (BlockState)Objects.requireNonNull(super.m_5573_(blockPlaceContext)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(bl));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        return (Boolean)blockState.m_61143_((Property)TOP) != false || levelReader.m_8055_(blockPos.m_7494_()).m_60713_((Block)ObjectRegistry.HANGING_ROPE.get());
    }

    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (!this.m_7898_(blockState, (LevelReader)serverLevel, blockPos)) {
            serverLevel.m_46961_(blockPos, true);
        }
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        ServerLevel serverLevel;
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).m_213780_().m_188501_() < 0.011377778f) {
            HangingRope.tryLowerRope(serverLevel, blockPos);
        }
        super.m_6402_(level, blockPos, blockState, livingEntity, itemStack);
    }

    public void m_6861_(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos blockPos2, boolean bl) {
        ServerLevel serverLevel;
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).m_213780_().m_188501_() < 0.011377778f) {
            HangingRope.tryLowerRope(serverLevel, blockPos);
        }
        super.m_6861_(blockState, level, blockPos, block, blockPos2, bl);
    }

    @NotNull
    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return super.m_7417_(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    @NotNull
    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    public boolean m_7357_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, PathComputationType pathComputationType) {
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TOP, WATERLOGGED});
    }
}

