/*
 * Decompiled with CFR 0.152.
 */
package satisfy.beachparty.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import satisfy.beachparty.recipe.MiniFridgeRecipe;
import satisfy.beachparty.recipe.TikiBarRecipe;

public class RecipeRegistry {
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((String)"beachparty", (ResourceKey)Registries.f_256764_);
    private static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((String)"beachparty", (ResourceKey)Registries.f_256954_);
    public static final RegistrySupplier<RecipeType<TikiBarRecipe>> TIKI_BAR_RECIPE_TYPE = RecipeRegistry.create("tiki_bar_mixing");
    public static final RegistrySupplier<RecipeSerializer<TikiBarRecipe>> TIKI_BAR_RECIPE_SERIALIZER = RecipeRegistry.create("tiki_bar_mixing", TikiBarRecipe.Serializer::new);
    public static final RegistrySupplier<RecipeType<MiniFridgeRecipe>> MINI_FRIDGE_RECIPE_TYPE = RecipeRegistry.create("mini_fridge_mixing");
    public static final RegistrySupplier<RecipeSerializer<MiniFridgeRecipe>> MINI_FRIDGE_RECIPE_SERIALIZER = RecipeRegistry.create("mini_fridge_mixing", MiniFridgeRecipe.Serializer::new);

    private static <T extends Recipe<?>> RegistrySupplier<RecipeSerializer<T>> create(String name, Supplier<RecipeSerializer<T>> serializer) {
        return RECIPE_SERIALIZERS.register(name, serializer);
    }

    private static <T extends Recipe<?>> RegistrySupplier<RecipeType<T>> create(final String name) {
        Supplier<RecipeType> type = () -> new RecipeType<T>(){

            public String toString() {
                return name;
            }
        };
        return RECIPE_TYPES.register(name, type);
    }

    public static void init() {
        RECIPE_SERIALIZERS.register();
        RECIPE_TYPES.register();
    }
}

