/*
 * Decompiled with CFR 0.152.
 */
package satisfy.beachparty.compat.jei;

import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.Block;
import satisfy.beachparty.BeachpartyIdentifier;
import satisfy.beachparty.client.gui.handler.MiniFridgeGuiHandler;
import satisfy.beachparty.client.gui.handler.TikiBarGuiHandler;
import satisfy.beachparty.compat.jei.categorys.MiniFridgeCategory;
import satisfy.beachparty.compat.jei.categorys.TikiBarCategory;
import satisfy.beachparty.registry.ObjectRegistry;
import satisfy.beachparty.registry.RecipeRegistry;
import satisfy.beachparty.registry.ScreenHandlerTypesRegistry;

@JeiPlugin
public class BeachpartyJEIPlugin
implements IModPlugin {
    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new MiniFridgeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new TikiBarCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager rm = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_7465_();
        List fridgeRecipes = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeRegistry.MINI_FRIDGE_RECIPE_TYPE.get());
        registration.addRecipes(MiniFridgeCategory.MINI_FRIDGE, fridgeRecipes);
        List tikiBarRecipes = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeRegistry.TIKI_BAR_RECIPE_TYPE.get());
        registration.addRecipes(TikiBarCategory.TIKI_BAR, tikiBarRecipes);
    }

    public ResourceLocation getPluginUid() {
        return new BeachpartyIdentifier("jei_plugin");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(((Block)ObjectRegistry.MINI_FRIDGE.get()).m_5456_().m_7968_(), new RecipeType[]{MiniFridgeCategory.MINI_FRIDGE});
        registration.addRecipeCatalyst(((Block)ObjectRegistry.TIKI_BAR.get()).m_5456_().m_7968_(), new RecipeType[]{TikiBarCategory.TIKI_BAR});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(MiniFridgeGuiHandler.class, (MenuType)ScreenHandlerTypesRegistry.MINI_FRIDGE_GUI_HANDLER.get(), MiniFridgeCategory.MINI_FRIDGE, 1, 2, 3, 36);
        registration.addRecipeTransferHandler(TikiBarGuiHandler.class, (MenuType)ScreenHandlerTypesRegistry.TIKI_BAR_GUI_HANDLER.get(), TikiBarCategory.TIKI_BAR, 1, 2, 3, 36);
    }

    public static void addSlot(IRecipeLayoutBuilder builder, int x, int y, Ingredient ingredient) {
        builder.addSlot(RecipeIngredientRole.INPUT, x, y).addIngredients(ingredient);
    }
}

