/*
 * Decompiled with CFR 0.152.
 */
package satisfy.beachparty.block;

import de.cristelknight.doapi.common.util.ChairUtil;
import de.cristelknight.doapi.common.util.GeneralUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import satisfy.beachparty.block.BeachChairBlock;

public class DeckChairBlock
extends BeachChairBlock {
    public static final EnumProperty<BedPart> PART = BlockStateProperties.f_61391_;
    private static final Supplier<VoxelShape> bottomShapeSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.25, (double)0.0, (double)1.0, (double)0.375, (double)1.0));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.25, (double)0.0, (double)1.0, (double)0.375, (double)1.0));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.36875, (double)0.0625, (double)1.0, (double)0.49375, (double)0.9375));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0, (double)0.1875, (double)0.25, (double)0.125));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.875, (double)0.1875, (double)0.25, (double)1.0));
        return shape;
    };
    public static final Map<Direction, VoxelShape> BOTTOM_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, GeneralUtil.rotateShape((Direction)Direction.EAST, (Direction)direction, (VoxelShape)bottomShapeSupplier.get()));
        }
    });
    private static final Supplier<VoxelShape> topShapeSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.25, (double)0.0, (double)0.3125, (double)0.375, (double)1.0));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.25, (double)0.0, (double)0.3125, (double)0.375, (double)1.0));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.36875, (double)0.0625, (double)0.25, (double)0.49375, (double)0.9375));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.0, (double)0.3125, (double)0.25, (double)0.125));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.875, (double)0.3125, (double)0.25, (double)1.0));
        return shape;
    };
    public static final Map<Direction, VoxelShape> TOP_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, GeneralUtil.rotateShape((Direction)Direction.EAST, (Direction)direction, (VoxelShape)topShapeSupplier.get()));
        }
    });

    public DeckChairBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        return state.m_61143_(PART) == BedPart.HEAD ? TOP_SHAPE.get(direction) : BOTTOM_SHAPE.get(direction);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Direction clickedFace = hit.m_82434_();
        if (state.m_61143_((Property)f_54117_) == clickedFace && state.m_61143_(PART) == BedPart.FOOT) {
            return ChairUtil.onUse((Level)world, (Player)player, (InteractionHand)hand, (BlockHitResult)hit, (double)0.1);
        }
        return InteractionResult.PASS;
    }
}

