/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarycreatures.entities;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarycreatures.entities.AnimatedCreatureEntity;
import sfiomn.legendarycreatures.entities.WispPurseEntity;
import sfiomn.legendarycreatures.entities.goals.FleeAirGoal;
import sfiomn.legendarycreatures.registry.EntityTypeRegistry;
import sfiomn.legendarycreatures.registry.ParticleTypeRegistry;
import sfiomn.legendarycreatures.registry.SoundRegistry;

public class WispEntity
extends AnimatedCreatureEntity
implements FlyingAnimal {
    public WispEntity(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, true);
        this.f_21344_ = new FlyingPathNavigation((Mob)this, level);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22280_, 0.35);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 5.0));
        this.f_21345_.m_25352_(2, new FleeAirGoal<Player>(this, Player.class, 40.0f, 1.0, 1.7));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal(this, 1.0, 10){

            protected Vec3 m_7037_() {
                int mobHeight = this.f_25725_.m_20183_().m_123342_() - this.f_25725_.m_9236_().m_6924_(Heightmap.Types.WORLD_SURFACE_WG, this.f_25725_.m_20183_().m_123341_(), this.f_25725_.m_20183_().m_123343_());
                int yOffset = mobHeight > 15 ? -4 : (mobHeight <= 3 ? 4 : 0);
                Vec3 viewVector = this.f_25725_.m_20252_(0.0f);
                return AirRandomPos.m_148387_((PathfinderMob)this.f_25725_, (int)10, (int)6, (int)yOffset, (Vec3)viewVector, (double)1.5707963705062866);
            }
        });
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            double offsetX = (2.0f * this.m_217043_().m_188501_() - 1.0f) * 0.3f;
            double offsetZ = (2.0f * this.m_217043_().m_188501_() - 1.0f) * 0.3f;
            double x = this.m_20182_().f_82479_ + offsetX;
            double y = this.m_20182_().f_82480_ + (double)(this.m_217043_().m_188501_() * 0.05f);
            double z = this.m_20182_().f_82481_ + offsetZ;
            if (this.m_9236_().m_46467_() % 3L == 0L) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypeRegistry.WISP_PARTICLE.get(), x, y, z, offsetX / 10.0, 0.01, offsetZ / 10.0);
            }
        }
    }

    public void m_20242_(boolean noGravity) {
        super.m_20242_(true);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.WISP_IDLE.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.WISP_DEATH.get();
    }

    protected WispPurseEntity getPurseEntity() {
        return (WispPurseEntity)((EntityType)EntityTypeRegistry.WISP_PURSE.get()).m_20615_(this.m_9236_());
    }

    public void m_142687_(@NotNull Entity.RemovalReason reason) {
        if (!this.m_9236_().f_46443_ && this.m_21224_() && !this.m_213877_()) {
            WispPurseEntity wispPurseEntity = this.getPurseEntity();
            if (wispPurseEntity == null) {
                return;
            }
            if (this.m_21532_()) {
                wispPurseEntity.m_21530_();
            }
            wispPurseEntity.m_20331_(this.m_20147_());
            wispPurseEntity.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.f_19796_.m_188501_() * 360.0f, this.f_19796_.m_188501_() * 360.0f);
            this.m_9236_().m_7967_((Entity)wispPurseEntity);
        }
        super.m_142687_(reason);
    }

    public boolean m_29443_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(@NotNull Entity entity) {
    }

    protected void m_6138_() {
    }

    protected void m_7840_(double p_27419_, boolean p_27420_, BlockState p_27421_, BlockPos p_27422_) {
    }

    public boolean m_6090_() {
        return true;
    }
}

