/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarycreatures.entities;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarycreatures.entities.AnimatedCreatureEntity;
import sfiomn.legendarycreatures.entities.goals.DelayedMeleeAttackGoal;
import sfiomn.legendarycreatures.registry.EffectRegistry;
import sfiomn.legendarycreatures.registry.SoundRegistry;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class PeacockSpiderEntity
extends AnimatedCreatureEntity
implements Enemy {
    private final int baseAttackDuration = 16;
    private final int baseAttackActionPoint = 10;
    private final int attackDelayTicks = 40;
    private int hissSoundTick = 40;
    private final RawAnimation RUN_ANIM = RawAnimation.begin().thenPlay("run");
    private final RawAnimation ATTACK_ANIM = RawAnimation.begin().thenPlay("attack");
    private final RawAnimation STARTLE_ANIM = RawAnimation.begin().thenPlay("startle");

    public PeacockSpiderEntity(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.f_21364_ = 5;
        if (this.isLevel3()) {
            this.f_21364_ = 20;
        } else if (this.isLevel2()) {
            this.f_21364_ = 10;
        }
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 18.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 0.5);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        if (!this.m_9236_().f_46443_) {
            int randomVariant = this.m_217043_().m_188503_(100);
            if (randomVariant >= 96) {
                this.setVariant(9);
            } else if (randomVariant >= 76) {
                this.setVariant(7);
            }
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag nbt) {
        AttributeInstance healthAttribute = this.m_21051_(Attributes.f_22276_);
        AttributeInstance attackAttribute = this.m_21051_(Attributes.f_22281_);
        if (this.isLevel2() || this.isLevel3()) {
            if (healthAttribute != null) {
                healthAttribute.m_22125_(new AttributeModifier(MAX_HEALTH_UUID, "legendarycreatures:peacock_spider_level2", 18.0, AttributeModifier.Operation.ADDITION));
                this.m_21153_(1000.0f);
            }
            if (attackAttribute != null) {
                if (this.isLevel3()) {
                    attackAttribute.m_22125_(new AttributeModifier(ATTACK_DAMAGE_UUID, "legendarycreatures:peacock_spider_level3", 12.0, AttributeModifier.Operation.ADDITION));
                } else {
                    attackAttribute.m_22125_(new AttributeModifier(ATTACK_DAMAGE_UUID, "legendarycreatures:peacock_spider_level2", 4.0, AttributeModifier.Operation.ADDITION));
                }
            }
        }
        return super.m_6518_(level, difficulty, spawnType, spawnGroupData, nbt);
    }

    public Component m_7755_() {
        String descriptionId = "entity.legendarycreatures.peacock_spider";
        if (this.isLevel2()) {
            descriptionId = "entity.legendarycreatures.peacock_spider2";
        } else if (this.isLevel3()) {
            descriptionId = "entity.legendarycreatures.peacock_spider3";
        }
        return Component.m_237115_((String)descriptionId);
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new BodyHelperController((Mob)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(4, (Goal)new DelayedMeleeAttackGoal(this, 40, 16, 10, 5, 1.0, true){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return PeacockSpiderEntity.this.getMobLength() * 2.0f * PeacockSpiderEntity.this.getMobLength() * 2.0f + entity.m_20205_();
            }

            @Override
            protected boolean executeAttack(LivingEntity target) {
                boolean hit = super.executeAttack(target);
                if (hit) {
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0, false, true));
                    target.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.CONVULSION.get(), 200, 0, false, true));
                }
                return hit;
            }
        });
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6, 40));
    }

    private float getMobLength() {
        return 1.4f;
    }

    @Override
    public <E extends GeoAnimatable> PlayState attackingPredicate(AnimationState<E> state) {
        if (this.hasSpawnEffect() && this.f_19797_ < this.getSpawnAnimationTicks()) {
            return PlayState.CONTINUE;
        }
        if (this.getAttackAnimation() == 1) {
            return state.setAndContinue(this.ATTACK_ANIM);
        }
        if (this.getAttackAnimation() == 6) {
            return state.setAndContinue(this.STARTLE_ANIM);
        }
        state.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.getAttackAnimation() == 6 && this.hissSoundTick++ >= 40) {
            this.hissSoundTick = 0;
            this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.PEACOCK_SPIDER_HISS.get(), SoundSource.HOSTILE, 10.0f, 1.0f);
        }
    }

    public boolean isLevel3() {
        return this.getVariant() >= 9;
    }

    public boolean isLevel2() {
        return this.getVariant() >= 7 && this.getVariant() < 9;
    }

    @Override
    public RawAnimation getSprintAnimation() {
        return this.RUN_ANIM;
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    protected float m_6431_(@NotNull Pose p_21131_, @NotNull EntityDimensions p_21132_) {
        return 0.3f;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.PEACOCK_SPIDER_DEATH.get();
    }

    @Override
    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        return (SoundEvent)SoundRegistry.PEACOCK_SPIDER_HURT.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        if (!this.m_20142_()) {
            this.m_5496_((SoundEvent)SoundRegistry.PEACOCK_SPIDER_STEP.get(), 1.0f, 1.0f);
        } else {
            this.m_5496_((SoundEvent)SoundRegistry.PEACOCK_SPIDER_RUN.get(), 1.0f, 1.0f);
        }
    }

    @NotNull
    protected ResourceLocation m_7582_() {
        if (this.isLevel2()) {
            return new ResourceLocation("legendarycreatures", "entities/peacock_spider_level2");
        }
        if (this.isLevel3()) {
            return new ResourceLocation("legendarycreatures", "entities/peacock_spider_level3");
        }
        return super.m_7582_();
    }

    class BodyHelperController
    extends BodyRotationControl {
        public BodyHelperController(Mob p_i49925_2_) {
            super(p_i49925_2_);
        }

        public void m_8121_() {
            PeacockSpiderEntity.this.f_20885_ = PeacockSpiderEntity.this.f_20883_;
            PeacockSpiderEntity.this.f_20883_ = PeacockSpiderEntity.this.m_146908_();
        }
    }
}

