/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarycreatures.entities;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarycreatures.entities.AnimatedCreatureEntity;
import sfiomn.legendarycreatures.entities.goals.BaseMeleeAttackGoal;
import sfiomn.legendarycreatures.entities.goals.ChargeMeleeAttackGoal;
import sfiomn.legendarycreatures.entities.goals.RootMeleeAttackGoal;
import sfiomn.legendarycreatures.registry.SoundRegistry;
import sfiomn.legendarycreatures.sounds.HoundRootAttackSound;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class HoundEntity
extends AnimatedCreatureEntity
implements Enemy {
    private final int chargeAttackDuration = 17;
    private final int chargeAttackActionPoint = 9;
    private final int biteAttackDuration = 12;
    private final int biteAttackActionPoint = 7;
    private final int biteLongAttackDuration = 26;
    private boolean playingRootAttackSound;
    private final RawAnimation RUN_ANIM = RawAnimation.begin().thenPlay("run");
    private final RawAnimation CHARGE_ANIM = RawAnimation.begin().thenPlay("charge");
    private final RawAnimation BITE_ANIM = RawAnimation.begin().thenPlay("bite");
    private final RawAnimation BITE_LONG_ANIM = RawAnimation.begin().thenPlay("bite_long");

    public HoundEntity(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.f_21364_ = 5;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.31).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22282_, 0.5);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (this.getAttackAnimation() == 4 && !this.playingRootAttackSound) {
                this.playingRootAttackSound = true;
                HoundRootAttackSound.startPlaying(this);
            } else if (this.getAttackAnimation() != 4 && this.playingRootAttackSound) {
                this.playingRootAttackSound = false;
            }
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        final ChargeMeleeAttackGoal chargeMeleeAttackGoal = new ChargeMeleeAttackGoal(this, 17, 9, 120, 8.0, 1.7, 30.0, true){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return HoundEntity.this.getMobLength() * 2.0f * HoundEntity.this.getMobLength() * 2.0f + entity.m_20205_();
            }

            @Override
            protected void executeAttack(LivingEntity target) {
                super.executeAttack(target);
                this.mob.m_5496_((SoundEvent)SoundRegistry.HOUND_BASE_ATTACK_HIT.get(), 1.0f, 1.0f);
            }
        };
        final RootMeleeAttackGoal rootMeleeAttackGoal = new RootMeleeAttackGoal(this, this.biteAttackDuration, this.biteAttackActionPoint, 78, 3.0f, 0.3, 1.0, 240){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return HoundEntity.this.getMobLength() * 2.0f * HoundEntity.this.getMobLength() * 2.0f + entity.m_20205_();
            }

            @Override
            protected void executeBaseAttack(LivingEntity target) {
                super.executeBaseAttack(target);
                this.mob.m_5496_((SoundEvent)SoundRegistry.HOUND_BASE_ATTACK_HIT.get(), 1.0f, 1.0f);
            }
        };
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(3, (Goal)chargeMeleeAttackGoal);
        this.f_21345_.m_25352_(4, (Goal)rootMeleeAttackGoal);
        this.f_21345_.m_25352_(5, (Goal)new BaseMeleeAttackGoal(this, 12, 7, 5, 1.3, true){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return HoundEntity.this.getMobLength() * 2.0f * HoundEntity.this.getMobLength() * 2.0f + entity.m_20205_();
            }

            @Override
            protected boolean executeAttack(LivingEntity target) {
                this.mob.m_5496_((SoundEvent)SoundRegistry.HOUND_BASE_ATTACK_HIT.get(), 1.0f, 1.0f);
                return super.executeAttack(target);
            }

            @Override
            public boolean m_8045_() {
                if (chargeMeleeAttackGoal.m_8036_() || rootMeleeAttackGoal.m_8036_()) {
                    return false;
                }
                return super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6, 40));
    }

    private float getMobLength() {
        return 1.4f;
    }

    @Override
    public <E extends GeoAnimatable> PlayState attackingPredicate(AnimationState<E> state) {
        if (this.hasSpawnEffect() && this.f_19797_ < this.getSpawnAnimationTicks()) {
            return PlayState.CONTINUE;
        }
        if (this.getAttackAnimation() == 1) {
            return state.setAndContinue(this.BITE_ANIM);
        }
        if (this.getAttackAnimation() == 2) {
            return state.setAndContinue(this.CHARGE_ANIM);
        }
        if (this.getAttackAnimation() == 4) {
            return state.setAndContinue(this.BITE_LONG_ANIM);
        }
        state.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    protected float m_6431_(@NotNull Pose p_21131_, @NotNull EntityDimensions p_21132_) {
        return 1.0f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.HOUND_IDLE.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.HOUND_DEATH.get();
    }

    @Override
    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        return (SoundEvent)SoundRegistry.HOUND_HURT.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        if (this.getAttackAnimation() == 3) {
            this.m_5496_(SoundEvents.f_11963_, 1.0f, 1.0f);
        } else {
            this.m_5496_((SoundEvent)SoundRegistry.HOUND_STEP.get(), 1.0f, 1.0f);
        }
    }

    @Override
    public RawAnimation getSprintAnimation() {
        return this.RUN_ANIM;
    }
}

