/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarycreatures.data;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import sfiomn.legendarycreatures.data.providers.ModBiomeTagsProvider;
import sfiomn.legendarycreatures.data.providers.ModBlockStateProvider;
import sfiomn.legendarycreatures.data.providers.ModDamageTypeTagsProvider;
import sfiomn.legendarycreatures.data.providers.ModDatapackBuiltinEntriesProvider;
import sfiomn.legendarycreatures.data.providers.ModItemModelProvider;
import sfiomn.legendarycreatures.data.providers.ModLootTableProvider;
import sfiomn.legendarycreatures.data.providers.ModParticleProvider;

@Mod.EventBusSubscriber(modid="legendarycreatures", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class DataGenerators {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput packOutput = gen.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        gen.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(packOutput, existingFileHelper));
        gen.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
        gen.addProvider(event.includeClient(), (DataProvider)new ModParticleProvider(packOutput, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ModBiomeTagsProvider(packOutput, lookupProvider, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ModDamageTypeTagsProvider(packOutput, lookupProvider, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ModDatapackBuiltinEntriesProvider(packOutput, lookupProvider));
        gen.addProvider(event.includeServer(), (DataProvider)ModLootTableProvider.createLootTables(packOutput));
    }
}

