/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.justhammers;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import pro.mikey.justhammers.HammerItems;
import pro.mikey.justhammers.HammerTags;

public class HammerItem
extends PickaxeItem {
    private final int depth;
    private final int radius;
    private TagKey<Block> blocks = BlockTags.f_144282_;

    public HammerItem(Tier tier, int radius, int depth, int level) {
        super(tier, 1, -2.8f, HammerItems.DEFAULT_PROPERTIES.m_41503_(HammerItem.computeDurability(tier, level)));
        this.depth = depth;
        this.radius = radius;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)Component.m_237110_((String)"justhammers.tooltip.size", (Object[])new Object[]{this.radius, this.radius, this.depth}).m_130940_(ChatFormatting.GRAY));
        int damage = itemStack.m_41773_();
        int maxDamage = itemStack.m_41776_();
        int durabilityPercentage = (int)((float)(maxDamage - damage) / (float)maxDamage * 100.0f);
        ChatFormatting color = ChatFormatting.GREEN;
        if (durabilityPercentage <= 50) {
            color = durabilityPercentage <= 25 ? ChatFormatting.RED : ChatFormatting.YELLOW;
        }
        int remaining = durabilityPercentage / 20;
        MutableComponent percentComponent = Component.m_237113_((String)(HammerItem.prettyDurability(damage) + "/" + HammerItem.prettyDurability(maxDamage) + " ")).m_7220_((Component)Component.m_237113_((String)"*".repeat(remaining)).m_130940_(color)).m_7220_((Component)Component.m_237113_((String)"*".repeat(5 - remaining)).m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)(" (" + durabilityPercentage + "%)")).m_130940_(ChatFormatting.GRAY));
        list.add((Component)percentComponent);
    }

    private static String prettyDurability(int durability) {
        String output;
        int unitIndex;
        String[] units = new String[]{"", "k", "m"};
        double displayDurability = durability;
        int n = unitIndex = durability > 0 ? (int)(Math.log10(durability) / 3.0) : 0;
        if (unitIndex >= units.length) {
            unitIndex = units.length - 1;
        }
        if ((output = String.format("%.2f", displayDurability /= Math.pow(1000.0, unitIndex))).endsWith(".00")) {
            output = output.substring(0, output.length() - 3);
        }
        return output + units[unitIndex];
    }

    private static int computeDurability(Tier tier, int level) {
        int baseModified = 0;
        if (level > 1) {
            baseModified = Tiers.NETHERITE.m_6609_();
        }
        return baseModified + ((int)((float)tier.m_6609_() * 2.5f) + 200 * level) * level;
    }

    public float m_8102_(ItemStack itemStack, BlockState blockState) {
        if (itemStack.m_41776_() - itemStack.m_41773_() <= 1) {
            return -1.0f;
        }
        return super.m_8102_(itemStack, blockState);
    }

    public boolean m_8096_(BlockState blockState) {
        return this.actualIsCorrectToolForDrops(blockState);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return this.actualIsCorrectToolForDrops(state);
    }

    public boolean actualIsCorrectToolForDrops(BlockState state) {
        int i = this.m_43314_().m_6604_();
        if (i < 3 && state.m_204336_(BlockTags.f_144284_)) {
            return false;
        }
        if (i < 2 && state.m_204336_(BlockTags.f_144285_)) {
            return false;
        }
        return (i >= 1 || !state.m_204336_(BlockTags.f_144286_)) && state.m_204336_(this.blocks);
    }

    public void causeAoe(Level level, BlockPos pos, BlockState state, ItemStack hammer, LivingEntity livingEntity) {
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        if (level.f_46443_ || state.m_60800_((BlockGetter)level, pos) == 0.0f) {
            return;
        }
        if (livingEntity.m_6047_()) {
            return;
        }
        HitResult pick = livingEntity.m_19907_(20.0, 0.0f, false);
        if (!(pick instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockHitResult = (BlockHitResult)pick;
        this.findAndBreakNearBlocks(blockHitResult, pos, hammer, level, livingEntity);
        if ((double)hammer.m_41773_() >= (double)hammer.m_41776_() * 0.95) {
            if (!hammer.m_41784_().m_128441_("has_been_warned")) {
                player.m_240418_((Component)Component.m_237115_((String)"justhammers.tooltip.durability_warning").m_130940_(ChatFormatting.RED), true);
                hammer.m_41784_().m_128379_("has_been_warned", true);
            }
        } else if (hammer.m_41784_().m_128441_("has_been_warned")) {
            hammer.m_41784_().m_128473_("has_been_warned");
        }
    }

    public void findAndBreakNearBlocks(BlockHitResult pick, BlockPos blockPos, ItemStack hammerStack, Level level, LivingEntity livingEntity) {
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        Direction direction = pick.m_82434_();
        BoundingBox boundingBox = HammerItem.getAreaOfEffect(blockPos, direction, this.radius, this.depth);
        if (!player.m_7500_() && hammerStack.m_41773_() >= hammerStack.m_41776_() - 1) {
            return;
        }
        int damage = 0;
        Iterator iterator = BlockPos.m_121919_((BoundingBox)boundingBox).iterator();
        HashSet<BlockPos> removedPos = new HashSet<BlockPos>();
        while (iterator.hasNext()) {
            boolean correctToolForDrops;
            EventResult eventResult;
            BlockPos pos = (BlockPos)iterator.next();
            if (!player.m_7500_() && hammerStack.m_41773_() + (damage + 1) >= hammerStack.m_41776_() - 1) break;
            BlockState targetState = level.m_8055_(pos);
            if (pos == blockPos || removedPos.contains(pos) || !this.canDestroy(targetState, level, pos) || !this.actualIsCorrectToolForDrops(targetState) || (eventResult = ((BlockEvent.Break)BlockEvent.BREAK.invoker()).breakBlock(level, pos, targetState, (ServerPlayer)livingEntity, null)).isFalse()) continue;
            removedPos.add(pos);
            level.m_46953_(pos, false, (Entity)livingEntity);
            if (!player.m_7500_() && (correctToolForDrops = hammerStack.m_41735_(targetState))) {
                targetState.m_222967_((ServerLevel)level, pos, hammerStack, true);
                List drops = Block.m_49874_((BlockState)targetState, (ServerLevel)((ServerLevel)level), (BlockPos)pos, (BlockEntity)level.m_7702_(pos), (Entity)livingEntity, (ItemStack)hammerStack);
                drops.forEach(e -> Block.m_152435_((Level)level, (BlockPos)pos, (Direction)pick.m_82434_(), (ItemStack)e));
            }
            ++damage;
        }
        if (damage != 0 && !player.m_7500_()) {
            hammerStack.m_41622_(damage, livingEntity, livingEntityx -> livingEntityx.m_21166_(EquipmentSlot.MAINHAND));
        }
    }

    public static BoundingBox getAreaOfEffect(BlockPos blockPos, Direction direction, int radius, int depth) {
        int size = radius / 2;
        int offset = size - 1;
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN, Direction.UP -> new BoundingBox(blockPos.m_123341_() - size, blockPos.m_123342_() - (direction == Direction.UP ? depth - 1 : 0), blockPos.m_123343_() - size, blockPos.m_123341_() + size, blockPos.m_123342_() + (direction == Direction.DOWN ? depth - 1 : 0), blockPos.m_123343_() + size);
            case Direction.NORTH, Direction.SOUTH -> new BoundingBox(blockPos.m_123341_() - size, blockPos.m_123342_() - size + offset, blockPos.m_123343_() - (direction == Direction.SOUTH ? depth - 1 : 0), blockPos.m_123341_() + size, blockPos.m_123342_() + size + offset, blockPos.m_123343_() + (direction == Direction.NORTH ? depth - 1 : 0));
            case Direction.WEST, Direction.EAST -> new BoundingBox(blockPos.m_123341_() - (direction == Direction.EAST ? depth - 1 : 0), blockPos.m_123342_() - size + offset, blockPos.m_123343_() - size, blockPos.m_123341_() + (direction == Direction.WEST ? depth - 1 : 0), blockPos.m_123342_() + size + offset, blockPos.m_123343_() + size);
        };
    }

    private boolean canDestroy(BlockState targetState, Level level, BlockPos pos) {
        if (targetState.m_60800_((BlockGetter)level, pos) <= 0.0f) {
            return false;
        }
        if (targetState.m_204336_(HammerTags.HAMMER_NO_SMASHY)) {
            return false;
        }
        return level.m_7702_(pos) == null;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getRadius() {
        return this.radius;
    }
}

