/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.mehvahdjukaar.jeed.Jeed;
import net.mehvahdjukaar.jeed.common.JsonHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EffectProviderRecipe
implements Recipe<CraftingContainer> {
    private final ResourceLocation id;
    @Nullable
    private final MobEffect effect;
    private final NonNullList<Ingredient> providers;
    public final List<MobEffect> effectProviders;
    public final List<Fluid> fluidProviders;

    public EffectProviderRecipe(ResourceLocation id, @Nullable MobEffect effect, NonNullList<Ingredient> providers, List<MobEffect> effectProviders, List<Fluid> fluidProviders) {
        this.id = id;
        this.effect = effect;
        this.providers = providers;
        this.fluidProviders = fluidProviders;
        this.effectProviders = effectProviders;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return "effect_provider";
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.providers;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        return false;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return Jeed.getEffectProviderSerializer();
    }

    public RecipeType<?> m_6671_() {
        return Jeed.getEffectProviderType();
    }

    public Collection<MobEffect> getEffects() {
        return this.effect == null ? BuiltInRegistries.f_256974_.m_123024_().toList() : Collections.singletonList(this.effect);
    }

    public static class Serializer
    implements RecipeSerializer<EffectProviderRecipe> {
        public EffectProviderRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String effectID;
            NonNullList<Ingredient> itemProviders = JsonHelper.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"providers"));
            JsonArray effects = json.getAsJsonArray("effect_providers");
            JsonArray fluids = json.getAsJsonArray("fluid_providers");
            if (itemProviders.isEmpty() && effects == null && fluids == null) {
                throw new JsonParseException("No item/effect or fluid providers for recipe");
            }
            JsonElement v = json.get("effect");
            if (v == null) {
                throw new JsonParseException("Missing effect for recipe");
            }
            if (v instanceof JsonObject) {
                JsonObject jo = (JsonObject)v;
                effectID = GsonHelper.m_13906_((JsonObject)jo, (String)"id");
            } else {
                effectID = v.getAsString();
            }
            MobEffect effect = null;
            if (effectID != null && !effectID.equals("all") && !effectID.equals("minecraft:all")) {
                effect = JsonHelper.getEffect(new ResourceLocation(effectID));
            }
            ArrayList<Fluid> fluids1 = new ArrayList<Fluid>();
            if (fluids != null) {
                for (JsonElement fluid : fluids) {
                    fluids1.add((Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(fluid.getAsString())));
                }
            }
            ArrayList<MobEffect> effects1 = new ArrayList<MobEffect>();
            if (effects != null) {
                for (JsonElement effect1 : effects) {
                    effects1.add((MobEffect)BuiltInRegistries.f_256974_.m_7745_(new ResourceLocation(effect1.getAsString())));
                }
            }
            return new EffectProviderRecipe(recipeId, effect, itemProviders, effects1, fluids1);
        }

        @NotNull
        public EffectProviderRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int i = buffer.m_130242_();
            NonNullList providers = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            providers.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buffer));
            ResourceLocation id = buffer.m_130281_();
            MobEffect effect = null;
            if (!id.m_135815_().equals("all")) {
                effect = JsonHelper.getEffect(id);
            }
            int fluids = buffer.m_130242_();
            ArrayList<Fluid> fluidProviders = new ArrayList<Fluid>();
            for (int j = 0; j < fluids; ++j) {
                fluidProviders.add((Fluid)BuiltInRegistries.f_257020_.m_7942_(buffer.m_130242_()));
            }
            int effects = buffer.m_130242_();
            ArrayList<MobEffect> effectProviders = new ArrayList<MobEffect>();
            for (int j = 0; j < effects; ++j) {
                effectProviders.add((MobEffect)BuiltInRegistries.f_256974_.m_7942_(buffer.m_130242_()));
            }
            return new EffectProviderRecipe(recipeId, effect, (NonNullList<Ingredient>)providers, effectProviders, fluidProviders);
        }

        public void toNetwork(FriendlyByteBuf buffer, EffectProviderRecipe recipe) {
            buffer.m_130130_(recipe.providers.size());
            for (Ingredient result : recipe.providers) {
                result.m_43923_(buffer);
            }
            ResourceLocation res = recipe.effect == null ? new ResourceLocation("all") : BuiltInRegistries.f_256974_.m_7981_((Object)recipe.effect);
            buffer.m_130085_(res);
            buffer.m_130130_(recipe.fluidProviders.size());
            for (Fluid fluid : recipe.fluidProviders) {
                buffer.m_130130_(BuiltInRegistries.f_257020_.m_7447_((Object)fluid));
            }
            buffer.m_130130_(recipe.effectProviders.size());
            for (MobEffect effect : recipe.effectProviders) {
                buffer.m_130130_(BuiltInRegistries.f_256974_.m_7447_((Object)effect));
            }
        }
    }
}

