/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.api;

import java.util.List;
import net.mehvahdjukaar.jeed.Jeed;
import net.mehvahdjukaar.jeed.api.IEffectScreenExtension;
import net.mehvahdjukaar.jeed.common.EffectRenderer;
import net.mehvahdjukaar.jeed.common.ScreenExtensionsHandler;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.TooltipFlag;

public class JeedAPI {
    public static <T extends AbstractContainerScreen<?>> void registerScreenExtension(Class<T> screenClass, IEffectScreenExtension<T> extension) {
        ScreenExtensionsHandler.registerScreenExtension(screenClass, extension);
    }

    public static void disableVanillaInventoryScreenExtension() {
        JeedAPI.disableExtension(CreativeModeInventoryScreen.class);
        JeedAPI.disableExtension(InventoryScreen.class);
        JeedAPI.disableExtension(EffectRenderingInventoryScreen.class);
    }

    public static <T extends AbstractContainerScreen> void disableExtension(Class<T> screenClass) {
        ScreenExtensionsHandler.unRegisterExtension(screenClass);
    }

    public static void invokeEffectClicked(MobEffectInstance effectInstance, double mouseX, double mouseY, int button) {
        Jeed.PLUGIN.onClickedEffect(effectInstance, mouseX, mouseY, button);
    }

    public static List<Component> getEffectTooltip(MobEffectInstance effectInstance, TooltipFlag tooltipFlag, boolean reactsToShift, boolean showDuration) {
        return EffectRenderer.getTooltipsWithDescription(effectInstance, tooltipFlag, reactsToShift, showDuration);
    }

    public static boolean isEffectHidden(Holder<MobEffect> effectInstance) {
        return effectInstance.m_203656_(Jeed.HIDDEN);
    }
}

