/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsrpgtweaks.enchantment_module;

import io.redspace.ironsrpgtweaks.config.ServerConfigs;
import io.redspace.ironsrpgtweaks.enchantment_module.EnchantModuleHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class EnchantmentClientEvents {
    public static final ResourceLocation ENCHANT_FONT = new ResourceLocation("alt");

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void modifyTooltip(ItemTooltipEvent event) {
        if (!((Boolean)ServerConfigs.ENCHANT_MODULE_ENABLED.get()).booleanValue()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        ListTag enchants = EnchantModuleHelper.getEnchantments(stack);
        List tooltipComponents = event.getToolTip();
        if (enchants != null && EnchantModuleHelper.shouldHideEnchantments(stack)) {
            for (int e = 0; e < enchants.size(); ++e) {
                CompoundTag compoundtag = enchants.m_128728_(e);
                Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(EnchantmentHelper.m_182446_((CompoundTag)compoundtag));
                if (enchantment == null) continue;
                String enchantKey = enchantment.m_44704_();
                for (int i = tooltipComponents.size() - 1; i >= 0; --i) {
                    ComponentContents componentContents = ((Component)tooltipComponents.get(i)).m_214077_();
                    if (!(componentContents instanceof TranslatableContents)) continue;
                    TranslatableContents translatableContents = (TranslatableContents)componentContents;
                    String tooltipKey = translatableContents.m_237508_();
                    if (tooltipKey.equals(enchantKey)) {
                        ((MutableComponent)tooltipComponents.get(i)).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131150_(ENCHANT_FONT));
                        continue;
                    }
                    if (!tooltipKey.contains(enchantKey)) continue;
                    tooltipComponents.remove(i);
                }
            }
        }
    }
}

