/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.client.render.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import immersive_paintings.Config;
import immersive_paintings.Main;
import immersive_paintings.entity.ImmersivePaintingEntity;
import immersive_paintings.resources.ClientPaintingManager;
import immersive_paintings.resources.ObjectLoader;
import immersive_paintings.resources.Painting;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import owens.oobjloader.Face;
import owens.oobjloader.FaceVertex;

public class ImmersivePaintingEntityRenderer<T extends ImmersivePaintingEntity>
extends EntityRenderer<T> {
    public ImmersivePaintingEntityRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(T entity, float yaw, float tickDelta, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light) {
        matrixStack.m_85836_();
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(-yaw));
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(-entity.m_5686_(tickDelta)));
        matrixStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
        this.renderPainting(matrixStack, vertexConsumerProvider, entity);
        matrixStack.m_85849_();
        super.m_7392_(entity, yaw, tickDelta, matrixStack, vertexConsumerProvider, light);
    }

    public ResourceLocation getTexture(T paintingEntity) {
        int resolution;
        Minecraft client = Minecraft.m_91087_();
        Config config = Config.getInstance();
        LocalPlayer player = client.f_91074_;
        double distance = player == null ? 0.0 : player.m_20182_().m_82554_(paintingEntity.m_20182_());
        double blocksVisible = Math.tan((double)((Integer)client.f_91066_.m_231837_().m_231551_()).intValue() / 180.0 * Math.PI / 2.0) * 2.0 * distance;
        double pixelDensity = blocksVisible * (double)(resolution = ClientPaintingManager.getPainting((ResourceLocation)((ImmersivePaintingEntity)((Object)paintingEntity)).getMotive()).resolution) / (double)client.m_91268_().m_85444_();
        Painting.Type type = pixelDensity > (double)config.eighthResolutionThreshold ? Painting.Type.EIGHTH : (pixelDensity > (double)config.quarterResolutionThreshold ? Painting.Type.QUARTER : (pixelDensity > (double)config.halfResolutionThreshold ? Painting.Type.HALF : Painting.Type.FULL));
        return ClientPaintingManager.getPaintingTexture((ResourceLocation)((ImmersivePaintingEntity)((Object)paintingEntity)).getMotive(), (Painting.Type)type).textureIdentifier;
    }

    protected int getLight(int light) {
        return light;
    }

    protected int getFrameLight(int light) {
        return light;
    }

    private void renderPainting(PoseStack matrices, MultiBufferSource vertexConsumerProvider, T entity) {
        int light = LevelRenderer.m_109541_((BlockAndTintGetter)entity.m_9236_(), (BlockPos)entity.m_20183_());
        PoseStack.Pose entry = matrices.m_85850_();
        Matrix4f posMat = entry.m_252922_();
        Matrix3f normMat = entry.m_252943_();
        boolean hasFrame = !((ImmersivePaintingEntity)((Object)entity)).getFrame().m_135815_().equals("none");
        int width = ((ImmersivePaintingEntity)((Object)entity)).getWidthPixels();
        int height = ((ImmersivePaintingEntity)((Object)entity)).getHeightPixels();
        VertexConsumer vertexConsumer = vertexConsumerProvider.m_6299_(this.isTranslucent() ? RenderType.m_110473_((ResourceLocation)this.getTexture(entity)) : RenderType.m_110446_((ResourceLocation)this.getTexture(entity)));
        this.renderFaces(this.isTranslucent() ? "objects/graffiti.obj" : "objects/canvas.obj", posMat, normMat, vertexConsumer, this.getLight(light), width, height, hasFrame ? 1.0f : 0.0f);
        int frameLight = this.getFrameLight(light);
        if (hasFrame) {
            vertexConsumer = vertexConsumerProvider.m_6299_(RenderType.m_110452_((ResourceLocation)((ImmersivePaintingEntity)((Object)entity)).getMaterial()));
            this.renderFrame(((ImmersivePaintingEntity)((Object)entity)).getFrame(), posMat, normMat, vertexConsumer, frameLight, width, height);
        }
    }

    protected boolean isTranslucent() {
        return false;
    }

    private void renderFaces(String name, Matrix4f posMat, Matrix3f normMat, VertexConsumer vertexConsumer, int light, float width, float height, float margin) {
        List<Face> faces = ObjectLoader.objects.get(Main.locate(name));
        for (Face face : faces) {
            for (FaceVertex v : face.vertices) {
                this.vertex(posMat, normMat, vertexConsumer, v.v.x * (width - margin * 2.0f), v.v.y * (height - margin * 2.0f), v.v.z * 16.0f, v.t.u * (width - margin * 2.0f) / width + margin / width, (1.0f - v.t.v) * (height - margin * 2.0f) / height + margin / height, v.n.x, v.n.y, v.n.z, light);
            }
        }
    }

    private List<Face> getFaces(ResourceLocation frame, String part) {
        ResourceLocation id = new ResourceLocation(frame.m_135827_(), frame.m_135815_() + "/" + part + ".obj");
        if (ObjectLoader.objects.containsKey(id)) {
            return ObjectLoader.objects.get(id);
        }
        return List.of();
    }

    private void renderFrame(ResourceLocation frame, Matrix4f posMat, Matrix3f normMat, VertexConsumer vertexConsumer, int light, float width, float height) {
        float u;
        List<Face> faces = this.getFaces(frame, "bottom");
        int x = 0;
        while ((float)x < width / 16.0f) {
            u = width == 16.0f ? 0.75f : (x == 0 ? 0.0f : ((float)x == width / 16.0f - 1.0f ? 0.5f : 0.25f));
            for (Face face : faces) {
                for (FaceVertex v : face.vertices) {
                    this.vertex(posMat, normMat, vertexConsumer, v.v.x + (float)(x * 16) - (width - 16.0f) / 2.0f, v.v.y - (height - 16.0f) / 2.0f, v.v.z, v.t.u * 0.25f + u, 1.0f - v.t.v, v.n.x, v.n.y, v.n.z, light);
                }
            }
            ++x;
        }
        faces = this.getFaces(frame, "top");
        x = 0;
        while ((float)x < width / 16.0f) {
            u = width == 16.0f ? 0.75f : (x == 0 ? 0.0f : ((float)x == width / 16.0f - 1.0f ? 0.5f : 0.25f));
            for (Face face : faces) {
                for (FaceVertex v : face.vertices) {
                    this.vertex(posMat, normMat, vertexConsumer, v.v.x + (float)(x * 16) - (width - 16.0f) / 2.0f, v.v.y + (height - 16.0f) / 2.0f, v.v.z, v.t.u * 0.25f + u, 1.0f - v.t.v, v.n.x, v.n.y, v.n.z, light);
                }
            }
            ++x;
        }
        faces = this.getFaces(frame, "right");
        int y = 0;
        while ((float)y < height / 16.0f) {
            u = 0.25f;
            for (Face face : faces) {
                for (FaceVertex v : face.vertices) {
                    this.vertex(posMat, normMat, vertexConsumer, v.v.x + (width - 16.0f) / 2.0f, v.v.y + (float)(y * 16) - (height - 16.0f) / 2.0f, v.v.z, v.t.u * 0.25f + u, 1.0f - v.t.v, v.n.x, v.n.y, v.n.z, light);
                }
            }
            ++y;
        }
        faces = this.getFaces(frame, "left");
        y = 0;
        while ((float)y < height / 16.0f) {
            u = 0.25f;
            for (Face face : faces) {
                for (FaceVertex v : face.vertices) {
                    this.vertex(posMat, normMat, vertexConsumer, v.v.x - (width - 16.0f) / 2.0f, v.v.y + (float)(y * 16) - (height - 16.0f) / 2.0f, v.v.z, v.t.u * 0.25f + u, 1.0f - v.t.v, v.n.x, v.n.y, v.n.z, light);
                }
            }
            ++y;
        }
    }

    private void vertex(Matrix4f positionMatrix, Matrix3f normalMatrix, VertexConsumer vertexConsumer, float x, float y, float z, float u, float v, float normalX, float normalY, float normalZ, int light) {
        vertexConsumer.m_252986_(positionMatrix, x, y, z - 0.5f).m_6122_(255, 255, 255, 255).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normalMatrix, normalX, normalY, normalZ).m_5752_();
    }
}

