/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.mixin.render;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.mortuusars.horseman.client.HorseRenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.item.DyeColor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntityRenderer.class}, priority=950)
public abstract class LivingEntityRendererMixin<T extends LivingEntity, M extends EntityModel<T>>
extends EntityRenderer<T> {
    protected LivingEntityRendererMixin(EntityRendererProvider.Context context) {
        super(context);
    }

    @WrapOperation(method={"render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/model/EntityModel;renderToBuffer(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;IIFFFF)V")})
    private void onRender(EntityModel<?> instance, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float r, float g, float b, float a, Operation<Void> original, @Local(argsOnly=true) T entity) {
        if (entity instanceof AbstractHorse) {
            double alphaVal;
            if (HorseRenderUtils.isJeb(entity)) {
                int index = ((LivingEntity)entity).f_19797_ / 25 + entity.m_19879_();
                int dyesCount = DyeColor.values().length;
                int currentIndex = index % dyesCount;
                int nextIndex = (index + 1) % dyesCount;
                float transition = ((float)(((LivingEntity)entity).f_19797_ % 25) + Minecraft.m_91087_().m_91297_()) / 25.0f;
                float[] currentColors = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)currentIndex));
                float[] nextColors = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)nextIndex));
                r = currentColors[0] * (1.0f - transition) + nextColors[0] * transition;
                g = currentColors[1] * (1.0f - transition) + nextColors[1] * transition;
                b = currentColors[2] * (1.0f - transition) + nextColors[2] * transition;
                r = Mth.m_14036_((float)(r * 2.0f), (float)0.0f, (float)1.0f);
                g = Mth.m_14036_((float)(g * 2.0f), (float)0.0f, (float)1.0f);
                b = Mth.m_14036_((float)(b * 2.0f), (float)0.0f, (float)1.0f);
            }
            if ((alphaVal = HorseRenderUtils.getAlpha(entity)) != 0.0) {
                a = (float)Mth.m_14008_((double)((double)a * alphaVal), (double)0.0, (double)1.0);
            }
        }
        instance.m_7695_(poseStack, vertexConsumer, packedLight, packedOverlay, r, g, b, a);
    }

    @Inject(method={"getRenderType"}, at={@At(value="HEAD")}, cancellable=true)
    private void getRenderType(T entity, boolean bodyVisible, boolean translucent, boolean glowing, CallbackInfoReturnable<RenderType> cir) {
        if (entity instanceof AbstractHorse && HorseRenderUtils.getAlpha(entity) < 1.0) {
            cir.setReturnValue((Object)RenderType.m_110473_((ResourceLocation)this.m_5478_((Entity)entity)));
        }
    }
}

