/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.horse;

import com.google.common.base.Preconditions;
import io.github.mortuusars.horseman.Config;
import io.github.mortuusars.horseman.Horseman;
import io.github.mortuusars.horseman.network.Packets;
import io.github.mortuusars.horseman.network.packet.client.SyncHorseDataS2CP;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public interface HitchableHorse {
    public ItemStack horseman$getLead();

    public void horseman$setLead(ItemStack var1);

    public boolean horseman$isHitched();

    public void horseman$setHitched(boolean var1);

    default public boolean horseman$hasLead() {
        return !this.horseman$getLead().m_41619_();
    }

    default public AbstractHorse horseman$asHorse() {
        return (AbstractHorse)this;
    }

    public static boolean isEnabled() {
        return (Boolean)Config.Common.HORSE_HITCH.get();
    }

    public static boolean requiresLead() {
        return (Boolean)Config.Common.HORSE_HITCH_REQUIRES_LEAD.get();
    }

    public static boolean isHitchable(HitchableHorse horse) {
        return !horse.horseman$asHorse().m_6095_().m_204039_(Horseman.Tags.EntityTypes.CANNOT_BE_HITCHED);
    }

    public static boolean canHitch(HitchableHorse horse) {
        return HitchableHorse.isEnabled() && HitchableHorse.isHitchable(horse) && !horse.horseman$asHorse().m_21523_() && (!HitchableHorse.requiresLead() || HitchableHorse.hasLead(horse));
    }

    public static boolean isHitched(HitchableHorse horse) {
        return horse.horseman$isHitched();
    }

    public static void setHitched(HitchableHorse horse, boolean hitched) {
        horse.horseman$setHitched(hitched);
    }

    public static ItemStack getLead(HitchableHorse horse) {
        return horse.horseman$getLead();
    }

    public static void setLead(HitchableHorse horse, ItemStack leadStack) {
        horse.horseman$setLead(leadStack);
    }

    public static boolean hasLead(HitchableHorse horse) {
        return horse.horseman$hasLead();
    }

    public static boolean shouldHaveLeadSlot(HitchableHorse horse) {
        return HitchableHorse.isEnabled() && HitchableHorse.requiresLead() && (Boolean)Config.Common.HORSE_HITCH_INVENTORY_SLOT.get() != false && HitchableHorse.isHitchable(horse);
    }

    public static int getLeadSlotIndex(HitchableHorse horse) {
        AbstractChestedHorse chestedHorse;
        Preconditions.checkState((boolean)HitchableHorse.shouldHaveLeadSlot(horse), (Object)"Tried to get lead slot index when the hitching is disabled or horse cannot be hitched.");
        if (horse instanceof AbstractChestedHorse && (chestedHorse = (AbstractChestedHorse)horse).m_30502_()) {
            int columns = ((AbstractChestedHorse)horse).m_7488_();
            return 2 + columns * 3;
        }
        return 2;
    }

    public static boolean mayPlaceInLeadSlot(HitchableHorse horse, ItemStack stack) {
        return stack.m_150930_(Items.f_42655_);
    }

    public static boolean isLeadSlotActive(HitchableHorse horse) {
        return !HitchableHorse.isHitched(horse);
    }

    public static void syncHorseDataToClient(HitchableHorse horse, ServerPlayer player) {
        Packets.sendToClient(new SyncHorseDataS2CP(horse.horseman$asHorse().m_19879_(), HitchableHorse.getHorseInventory(horse), HitchableHorse.getLead(horse), HitchableHorse.isHitched(horse)), player);
    }

    public static void syncHorseDataToTrackingClients(HitchableHorse horse) {
        Packets.sendToPlayersTrackingEntity((Entity)horse.horseman$asHorse(), new SyncHorseDataS2CP(horse.horseman$asHorse().m_19879_(), HitchableHorse.getHorseInventory(horse), HitchableHorse.getLead(horse), HitchableHorse.isHitched(horse)));
    }

    private static List<ItemStack> getHorseInventory(HitchableHorse horse) {
        SimpleContainer inventory = horse.horseman$asHorse().f_30520_;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            items.add(inventory.m_8020_(i));
        }
        return items;
    }
}

