/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman;

import com.google.common.base.Preconditions;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.horseman.Register;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.StatFormatter;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import org.slf4j.Logger;

public class Horseman {
    public static final String ID = "horseman";
    public static final Logger LOGGER = LogUtils.getLogger();

    public static void init() {
        Blocks.init();
        BlockEntityTypes.init();
        EntityTypes.init();
        Items.init();
        MenuTypes.init();
        RecipeSerializers.init();
        SoundEvents.init();
        ArgumentTypes.init();
    }

    public static ResourceLocation resource(String path) {
        return new ResourceLocation(ID, path);
    }

    public static class Blocks {
        static void init() {
        }
    }

    public static class BlockEntityTypes {
        static void init() {
        }
    }

    public static class EntityTypes {
        static void init() {
        }
    }

    public static class Items {
        static void init() {
        }
    }

    public static class MenuTypes {
        static void init() {
        }
    }

    public static class RecipeSerializers {
        static void init() {
        }
    }

    public static class SoundEvents {
        private static Supplier<SoundEvent> register(String category, String key) {
            Preconditions.checkState((category != null && !category.isEmpty() ? 1 : 0) != 0, (Object)"'category' should not be empty.");
            Preconditions.checkState((key != null && !key.isEmpty() ? 1 : 0) != 0, (Object)"'key' should not be empty.");
            String path = category + "." + key;
            return Register.soundEvent(path, () -> SoundEvent.m_262824_((ResourceLocation)Horseman.resource(path)));
        }

        static void init() {
        }
    }

    public static class ArgumentTypes {
        public static void init() {
        }
    }

    public static class Tags {

        public static class EntityTypes {
            public static final TagKey<EntityType<?>> CANNOT_BE_HITCHED = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)Horseman.resource("cannot_be_hitched"));
            public static final TagKey<EntityType<?>> CANNOT_SWIM = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)Horseman.resource("cannot_swim"));
            public static final TagKey<EntityType<?>> FORBIDS_HORSES = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)Horseman.resource("forbids_horses"));
        }

        public static class Blocks {
        }

        public static class Items {
        }
    }

    public static class Advancements {
        public static void register() {
        }
    }

    public static class Stats {
        private static final Map<ResourceLocation, StatFormatter> STATS = new HashMap<ResourceLocation, StatFormatter>();

        private static ResourceLocation register(ResourceLocation location, StatFormatter formatter) {
            STATS.put(location, formatter);
            return location;
        }

        public static void register() {
            STATS.forEach((location, formatter) -> {
                Registry.m_122965_((Registry)BuiltInRegistries.f_256771_, (ResourceLocation)location, (Object)location);
                net.minecraft.stats.Stats.f_12988_.m_12899_(location, formatter);
            });
        }
    }

    public static class EntityAttributes {
        public static final ResourceLocation MOUNTED_STEP_HEIGHT = Horseman.resource("mounted-step-height");
        public static final ResourceLocation MOUNTED_BREAK_SPEED = Horseman.resource("mounted-break-speed");
    }
}

