/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.games.gamediscs;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.phys.Vec2;
import net.tejty.gamediscs.games.controls.Button;
import net.tejty.gamediscs.games.graphics.BasicParticleRenderer;
import net.tejty.gamediscs.games.graphics.MultiImage;
import net.tejty.gamediscs.games.graphics.ParticleColor;
import net.tejty.gamediscs.games.util.BlocktrisPiece;
import net.tejty.gamediscs.games.util.Game;
import net.tejty.gamediscs.games.util.GameStage;
import net.tejty.gamediscs.games.util.Grid;
import net.tejty.gamediscs.games.util.ParticleLevel;
import net.tejty.gamediscs.sounds.SoundRegistry;

public class BlocktrisGame
extends Game {
    public Grid grid;
    private BlocktrisPiece piece;
    private BlocktrisPiece hold = null;
    private List<BlocktrisPiece> nexts = new ArrayList<BlocktrisPiece>();
    private int placementCooldown = 0;
    private boolean switched = false;

    public BlocktrisGame() {
        this.grid = new Grid(10, 23, 5, new MultiImage(new ResourceLocation("gamediscs", "textures/games/sprite/cubes.png"), 5, 40, 8));
        int type = this.random.nextInt(7);
        this.piece = new BlocktrisPiece(BlocktrisPiece.PIECES.get(type).get(), 4, 1, type, this);
    }

    @Override
    public synchronized void prepare() {
        super.prepare();
        this.grid = new Grid(10, 23, 5, new MultiImage(new ResourceLocation("gamediscs", "textures/games/sprite/cubes.png"), 5, 40, 8));
        int type = this.random.nextInt(0, 7);
        this.piece = new BlocktrisPiece(BlocktrisPiece.PIECES.get(type).get(), 4, 1, type, this);
        this.nexts.clear();
        this.hold = null;
    }

    @Override
    public synchronized void start() {
        super.start();
        for (int i = 0; i < 3; ++i) {
            int type = this.random.nextInt(0, 7);
            this.nexts.add(new BlocktrisPiece(BlocktrisPiece.PIECES.get(type).get(), 4, 1, type, this));
        }
        this.placementCooldown = 0;
        this.switched = false;
    }

    @Override
    public synchronized void gameTick() {
        if (this.piece.move(0, 1)) {
            this.placePiece();
        }
    }

    @Override
    public int gameTickDuration() {
        return (int)(10.0f / ((float)this.score / 50.0f + 1.0f));
    }

    @Override
    public synchronized void render(GuiGraphics graphics, int posX, int posY) {
        super.render(graphics, posX, posY);
        this.grid.render(graphics, posX + 45, posY - 15);
        this.piece.render(graphics, posX + 45, posY - 15);
        for (int i = 0; i < this.nexts.size(); ++i) {
            BlocktrisPiece next = this.nexts.get(i);
            next.setRotation(1);
            next.setPos(23, 4 + i * 3);
            next.renderCentered(graphics, posX, posY);
        }
        if (this.hold != null) {
            this.hold.setRotation(1);
            this.hold.setPos(4, 6);
            this.hold.renderCentered(graphics, posX, posY);
        }
        Font font = Minecraft.m_91087_().f_91062_;
        MutableComponent text = Component.m_237115_((String)"gui.gamingconsole.hold");
        graphics.m_280614_(font, (Component)text, 22 + posX - font.m_92724_(text.m_7532_()) / 2, 16 + posY, 0x555555, false);
        text = Component.m_237115_((String)"gui.gamingconsole.next");
        graphics.m_280614_(font, (Component)text, 118 + posX - font.m_92724_(text.m_7532_()) / 2, 6 + posY, 0x555555, false);
        this.renderParticles(graphics, posX, posY);
        this.renderOverlay(graphics, posX, posY);
    }

    @Override
    public synchronized void buttonDown(Button button) {
        super.buttonDown(button);
        if (this.stage == GameStage.PLAYING && this.ticks > 5) {
            if (button == Button.UP) {
                this.piece.rotate();
                this.soundPlayer.play((SoundEvent)SoundRegistry.SWING.get(), 1.5f, 0.5f);
                this.placementCooldown = 10;
            }
            if (button == Button.LEFT) {
                this.piece.move(-1, 0);
                this.soundPlayer.play((SoundEvent)SoundRegistry.SHOOT.get(), 2.5f, 0.1f);
                this.placementCooldown = 10;
            }
            if (button == Button.RIGHT) {
                this.piece.move(1, 0);
                this.soundPlayer.play((SoundEvent)SoundRegistry.SHOOT.get(), 2.5f, 0.1f);
                this.placementCooldown = 10;
            }
            if (button == Button.DOWN) {
                this.soundPlayer.play((SoundEvent)SoundRegistry.SHOOT.get(), 2.5f, 0.1f);
                if (this.piece.move(0, 1)) {
                    this.placePiece();
                } else {
                    this.placementCooldown = 10;
                }
            }
            if (button == Button.BUTTON1) {
                this.soundPlayer.play((SoundEvent)SoundRegistry.EXPLOSION.get(), 0.7f, 0.5f);
                this.piece.hardDrop();
                this.placePiece();
            }
            if (button == Button.BUTTON2 && !this.switched) {
                this.soundPlayer.play((SoundEvent)SoundRegistry.SWITCH.get(), 0.6f, 0.5f);
                BlocktrisPiece oldHold = this.hold;
                this.hold = this.piece;
                this.piece = oldHold != null ? oldHold : this.getNext();
                this.piece.setPos(4, 1);
                this.switched = true;
            }
        }
    }

    @Override
    public synchronized void tick() {
        super.tick();
        if (this.stage == GameStage.PLAYING && this.ticks % 2 == 0) {
            if (this.controls.isButtonDown(Button.LEFT) && !this.controls.wasButtonDown(Button.LEFT)) {
                this.piece.move(-1, 0);
                this.soundPlayer.play((SoundEvent)SoundRegistry.SHOOT.get(), 2.5f, 0.1f);
            }
            if (this.controls.isButtonDown(Button.RIGHT) && !this.controls.wasButtonDown(Button.RIGHT)) {
                this.piece.move(1, 0);
                this.soundPlayer.play((SoundEvent)SoundRegistry.SHOOT.get(), 2.5f, 0.1f);
            }
            if (this.controls.isButtonDown(Button.DOWN) && !this.controls.wasButtonDown(Button.DOWN)) {
                this.soundPlayer.play((SoundEvent)SoundRegistry.SHOOT.get(), 2.5f, 0.1f);
                if (this.piece.move(0, 1)) {
                    this.placePiece();
                }
            }
        }
        --this.placementCooldown;
        if (this.placementCooldown < 0) {
            this.placementCooldown = 0;
        }
    }

    private void placePiece() {
        this.switched = false;
        if (this.placementCooldown <= 0) {
            this.piece.place();
            int combo = 0;
            for (int y = this.grid.height() - 1; y >= 0; --y) {
                boolean isFull = true;
                for (int x = 0; x < this.grid.width(); ++x) {
                    if (this.grid.get(x, y) != 0) continue;
                    isFull = false;
                }
                if (!isFull) continue;
                ++combo;
                for (int line = y - 1; line >= 0; --line) {
                    for (int x = 0; x < this.grid.width(); ++x) {
                        if (line == y - 1) {
                            this.spawnParticleExplosion(() -> new BasicParticleRenderer(ParticleColor.random(this.random)), new Vec2((float)(45 + x * 5), (float)(y * 5 - 15)), 4, 3, 5, ParticleLevel.RUNNING_GAME);
                        }
                        this.grid.set(x, line + 1, this.grid.get(x, line));
                    }
                }
                ++y;
            }
            this.score += combo * combo;
            if (combo > 0) {
                this.soundPlayer.playPoint();
            }
            this.piece = this.getNext();
            this.piece.setPos(4, 1);
            if (this.piece.isTouching()) {
                this.die();
            }
        }
    }

    private BlocktrisPiece getNext() {
        BlocktrisPiece toReturn = this.nexts.get(0);
        this.nexts.remove(0);
        int type = this.random.nextInt(0, 7);
        this.nexts.add(new BlocktrisPiece(BlocktrisPiece.PIECES.get(type).get(), 4, 1, type, this));
        toReturn.setPos(4, 1);
        toReturn.setRotation(0);
        return toReturn;
    }

    @Override
    public ResourceLocation getBackground() {
        return new ResourceLocation("gamediscs", "textures/games/background/blocktris_bakground.png");
    }

    @Override
    public boolean showScoreBox() {
        return false;
    }

    @Override
    public boolean scoreText() {
        return false;
    }

    @Override
    public Component getName() {
        return Component.m_237115_((String)"gamediscs.blocktris");
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocation("gamediscs", "textures/item/game_disc_blocktris.png");
    }
}

