/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.recipe.pigment;

import ky.someone.mods.gag.item.ItemRegistry;
import ky.someone.mods.gag.item.PigmentJarItem;
import ky.someone.mods.gag.misc.Pigment;
import ky.someone.mods.gag.recipe.GAGRecipeSerializers;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class PigmentJarSplittingRecipe
extends CustomRecipe {
    public PigmentJarSplittingRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer container, Level level) {
        boolean filled = false;
        boolean empty = false;
        for (ItemStack stack : container.m_280657_()) {
            if (!stack.m_150930_((Item)ItemRegistry.PIGMENT_JAR.get())) continue;
            if (PigmentJarItem.isEmpty(stack)) {
                if (empty) {
                    return false;
                }
                empty = true;
                continue;
            }
            if (filled) {
                return false;
            }
            filled = true;
        }
        return filled && empty;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess reg) {
        for (ItemStack stack : container.m_280657_()) {
            Pigment pigment;
            if (!stack.m_150930_((Item)ItemRegistry.PIGMENT_JAR.get()) || (pigment = PigmentJarItem.getPigment(stack)) == null || pigment.isEmpty()) continue;
            Pigment newStack = pigment.withAmount(pigment.amount() / 2);
            return newStack.asJar().m_255036_(2);
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int i, int j) {
        return i * j >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)GAGRecipeSerializers.PIGMENT_JAR_SPLITTING.get();
    }
}

