/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.recipe.pigment;

import ky.someone.mods.gag.item.ItemRegistry;
import ky.someone.mods.gag.item.PigmentJarItem;
import ky.someone.mods.gag.misc.Pigment;
import ky.someone.mods.gag.recipe.GAGRecipeSerializers;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class PigmentJarFromDyeRecipe
extends CustomRecipe {
    public PigmentJarFromDyeRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer container, Level level) {
        boolean emptyJar = false;
        boolean flint = false;
        boolean milk = false;
        DyeColor dye = null;
        int dyeAmount = 0;
        for (ItemStack stack : container.m_280657_()) {
            if (!emptyJar && stack.m_150930_((Item)ItemRegistry.PIGMENT_JAR.get()) && PigmentJarItem.isEmpty(stack)) {
                emptyJar = true;
                continue;
            }
            if (!flint && stack.m_150930_(Items.f_42484_)) {
                flint = true;
                continue;
            }
            if (!milk && stack.m_150930_(Items.f_42455_)) {
                milk = true;
                continue;
            }
            Item item = stack.m_41720_();
            if (item instanceof DyeItem) {
                DyeItem dyeItem = (DyeItem)item;
                if (dye == null) {
                    dye = dyeItem.m_41089_();
                    dyeAmount = 1;
                    continue;
                }
                if (dye == dyeItem.m_41089_()) {
                    ++dyeAmount;
                    continue;
                }
                return false;
            }
            if (stack.m_41619_()) continue;
            return false;
        }
        return emptyJar && flint && milk && dye != null;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess reg) {
        DyeColor dye = null;
        int amount = 0;
        for (ItemStack stack : container.m_280657_()) {
            Item item = stack.m_41720_();
            if (!(item instanceof DyeItem)) continue;
            DyeItem dyeItem = (DyeItem)item;
            if (dye == null) {
                dye = dyeItem.m_41089_();
                amount = 1;
                continue;
            }
            if (dye == dyeItem.m_41089_()) {
                ++amount;
                continue;
            }
            return ItemStack.f_41583_;
        }
        if (dye == null) {
            return ItemStack.f_41583_;
        }
        if ((amount *= 4) > 64) {
            return ItemStack.f_41583_;
        }
        return Pigment.forText(dye).withAmount(amount).asJar();
    }

    public boolean m_8004_(int i, int j) {
        return i >= 2 && j >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)GAGRecipeSerializers.PIGMENT_JAR_FROM_DYE.get();
    }
}

