/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.inventory;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.inventory.ILockable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class BigInventoryHandler
implements IItemHandler,
INBTSerializable<CompoundTag>,
ILockable {
    public static String BIG_ITEMS = "BigItems";
    public static String STACK = "Stack";
    public static String AMOUNT = "Amount";
    private final FunctionalStorage.DrawerType type;
    private List<BigStack> storedStacks;

    public BigInventoryHandler(FunctionalStorage.DrawerType type) {
        this.type = type;
        this.storedStacks = new ArrayList<BigStack>();
        for (int i = 0; i < type.getSlots(); ++i) {
            this.storedStacks.add(i, new BigStack(ItemStack.f_41583_, 0));
        }
    }

    public int getSlots() {
        if (this.isVoid()) {
            return this.type.getSlots() + 1;
        }
        return this.type.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (this.type.getSlots() == slot) {
            return ItemStack.f_41583_;
        }
        BigStack bigStack = this.storedStacks.get(slot);
        ItemStack copied = bigStack.getStack().m_41777_();
        copied.m_41764_(this.isCreative() ? Integer.MAX_VALUE : bigStack.getAmount());
        return copied;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.isVoid() && this.type.getSlots() == slot && this.isVoidValid(stack) || this.isVoidValid(stack) && this.isCreative()) {
            return ItemStack.f_41583_;
        }
        if (this.isValid(slot, stack)) {
            BigStack bigStack = this.storedStacks.get(slot);
            int inserted = Math.min(this.getSlotLimit(slot) - bigStack.getAmount(), stack.m_41613_());
            if (!simulate) {
                if (bigStack.getStack().m_41619_()) {
                    bigStack.setStack(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)stack.m_41741_()));
                }
                bigStack.setAmount(Math.min(bigStack.getAmount() + inserted, this.getSlotLimit(slot)));
                this.onChange();
            }
            if (inserted == stack.m_41613_() || this.isVoid()) {
                return ItemStack.f_41583_;
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - inserted));
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0 || this.type.getSlots() == slot) {
            return ItemStack.f_41583_;
        }
        if (slot < this.type.getSlots()) {
            BigStack bigStack = this.storedStacks.get(slot);
            if (bigStack.getStack().m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (!this.isCreative() && bigStack.getAmount() <= amount) {
                ItemStack out = bigStack.getStack().m_41777_();
                int newAmount = bigStack.getAmount();
                if (!simulate && !this.isCreative()) {
                    if (!this.isLocked()) {
                        bigStack.setStack(ItemStack.f_41583_);
                    }
                    bigStack.setAmount(0);
                    this.onChange();
                }
                out.m_41764_(newAmount);
                return out;
            }
            if (!simulate && !this.isCreative()) {
                bigStack.setAmount(bigStack.getAmount() - amount);
                this.onChange();
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)bigStack.getStack(), (int)amount);
        }
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        if (this.isCreative()) {
            return Integer.MAX_VALUE;
        }
        if (this.type.getSlots() == slot) {
            return Integer.MAX_VALUE;
        }
        double stackSize = 1.0;
        if (!this.getStoredStacks().get(slot).getStack().m_41619_()) {
            stackSize = (double)this.getStoredStacks().get(slot).getStack().m_41741_() / 64.0;
        }
        int slotAmount = this.type.getSlotAmount();
        if (this.hasDowngrade()) {
            slotAmount = 64;
        }
        return (int)Math.floor((double)Math.min(Integer.MAX_VALUE, (long)slotAmount * (long)this.getMultiplier()) * stackSize);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return !stack.m_41619_();
    }

    private boolean isValid(int slot, @Nonnull ItemStack stack) {
        if (slot < this.type.getSlots()) {
            BigStack bigStack = this.storedStacks.get(slot);
            ItemStack fl = bigStack.getStack();
            if (this.isLocked() && fl.m_41619_()) {
                return false;
            }
            return fl.m_41619_() || ItemStack.m_150942_((ItemStack)fl, (ItemStack)stack);
        }
        return false;
    }

    private boolean isVoidValid(ItemStack stack) {
        for (BigStack storedStack : this.storedStacks) {
            if (!ItemStack.m_150942_((ItemStack)storedStack.getStack(), (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        CompoundTag items = new CompoundTag();
        for (int i = 0; i < this.storedStacks.size(); ++i) {
            CompoundTag bigStack = new CompoundTag();
            bigStack.m_128365_(STACK, (Tag)this.storedStacks.get(i).getStack().serializeNBT());
            bigStack.m_128405_(AMOUNT, this.storedStacks.get(i).getAmount());
            items.m_128365_("" + i, (Tag)bigStack);
        }
        compoundTag.m_128365_(BIG_ITEMS, (Tag)items);
        return compoundTag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        for (String allKey : nbt.m_128469_(BIG_ITEMS).m_128431_()) {
            this.storedStacks.get(Integer.parseInt(allKey)).setStack(ItemStack.m_41712_((CompoundTag)nbt.m_128469_(BIG_ITEMS).m_128469_(allKey).m_128469_(STACK)));
            this.storedStacks.get(Integer.parseInt(allKey)).setAmount(nbt.m_128469_(BIG_ITEMS).m_128469_(allKey).m_128451_(AMOUNT));
        }
    }

    public abstract void onChange();

    public abstract int getMultiplier();

    public abstract boolean isVoid();

    public abstract boolean hasDowngrade();

    @Override
    public abstract boolean isLocked();

    public abstract boolean isCreative();

    public List<BigStack> getStoredStacks() {
        return this.storedStacks;
    }

    public static class BigStack {
        private ItemStack stack;
        private int amount;

        public BigStack(ItemStack stack, int amount) {
            this.stack = stack.m_41777_();
            this.amount = amount;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void setStack(ItemStack stack) {
            this.stack = stack.m_41777_();
        }

        public int getAmount() {
            return this.amount;
        }

        public void setAmount(int amount) {
            this.amount = amount;
        }
    }
}

