/*
 * Decompiled with CFR 0.152.
 */
package me.litchi.ftbqlocal.utils;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.text2speech.Narrator;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.ChapterGroup;
import dev.ftb.mods.ftbquests.quest.ChapterImage;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import me.litchi.ftbqlocal.commands.FTBQLangConvert;
import me.litchi.ftbqlocal.handler.FtbQHandler;
import me.litchi.ftbqlocal.utils.Constants;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackPortUtils
implements FtbQHandler {
    private static final String KUBEJS_LANG_DIR = Constants.PackMCMeta.GAMEDIR + "\\FTBLang\\backup\\kubejs\\assets\\ftbquestlocalizer\\lang\\\\";
    private static final String RESOURCE_LANG_DIR = Constants.PackMCMeta.GAMEDIR + "\\resourcepacks\\FTB-Quest-Localization-Resourcepack.zip";
    private static final Logger log = LoggerFactory.getLogger(BackPortUtils.class);
    private static JsonObject defaultJSON = null;
    private static JsonObject enJson = null;
    private static final List<String> descList = new ArrayList<String>();
    private static final BackPortUtils backportU = new BackPortUtils();
    private static final Map<Long, List<String>> newdescMap = new HashMap<Long, List<String>>();
    private static final Map<Long, List<String>> chapterSubMap = new HashMap<Long, List<String>>();
    private static final Map<Long, List<ChapterImage>> chapterImageList = new HashMap<Long, List<ChapterImage>>();
    private static final Map<String, List<String>> hoverTextMap = new HashMap<String, List<String>>();

    public static void backport(String langStr) {
        try {
            enJson = JsonParser.parseString((String)FileUtils.readFileToString((File)new File(KUBEJS_LANG_DIR + "en_us.json"), (Charset)StandardCharsets.UTF_8)).getAsJsonObject();
        }
        catch (IOException e) {
            log.info("en_us.json is null");
        }
        defaultJSON = null;
        try {
            File kubefile;
            BaseQuestFile questFile = FTBQuestsAPI.api().getQuestFile(false);
            if (langStr.equals("en_us")) {
                newdescMap.clear();
                chapterSubMap.clear();
                chapterImageList.clear();
                questFile.forAllQuests(quest -> newdescMap.put(quest.id, new ArrayList(quest.getRawDescription())));
                questFile.forAllChapters(chapter -> {
                    chapterImageList.put(chapter.id, new ArrayList(chapter.getImages()));
                    try {
                        Field hoverText = ChapterImage.class.getDeclaredField("hover");
                        hoverText.setAccessible(true);
                        long num = 0L;
                        for (ChapterImage image : chapter.getImages()) {
                            List textList = (List)hoverText.get(image);
                            hoverTextMap.put(String.valueOf(chapter.id) + num, textList);
                            ++num;
                        }
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        log.info(e.getMessage());
                    }
                    chapterSubMap.put(chapter.id, new ArrayList(chapter.getRawSubtitle()));
                });
            }
            if (!(kubefile = new File(KUBEJS_LANG_DIR + langStr + ".json")).exists()) {
                try (ZipFile zipFile = new ZipFile(RESOURCE_LANG_DIR);){
                    zipFile.stream().forEach(zipEntry -> {
                        if (!zipEntry.isDirectory()) {
                            try {
                                if (zipEntry.getName().equals(langStr + ".json")) {
                                    byte[] bytes = zipFile.getInputStream((ZipEntry)zipEntry).readAllBytes();
                                    defaultJSON = JsonParser.parseString((String)new String(bytes)).getAsJsonObject();
                                }
                            }
                            catch (IOException e) {
                                log.info("JsonFile error");
                            }
                        }
                    });
                }
                catch (Exception e) {
                    log.info("ZIPFile error");
                }
            } else {
                String defaultLang = FileUtils.readFileToString((File)kubefile, (Charset)StandardCharsets.UTF_8);
                defaultJSON = JsonParser.parseString((String)defaultLang).getAsJsonObject();
            }
            if (defaultJSON == null) {
                if (!langStr.equals("en_us")) {
                    defaultJSON = enJson;
                } else {
                    log.info("defaultJson is null");
                }
            }
            backportU.handleRewardTables(questFile.getRewardTables());
            questFile.forAllChapterGroups(backportU::handleChapterGroup);
            questFile.forAllChapters(chapter -> {
                backportU.handleChapter((Chapter)chapter);
                backportU.handleQuests(chapter.getQuests());
            });
            File output = new File(Constants.PackMCMeta.GAMEDIR, "config\\ftbquests\\quests\\");
            questFile.writeDataFull(output.toPath());
            ServerQuestFile.INSTANCE.markDirty();
            ServerQuestFile.INSTANCE.saveNow();
            if (langStr.equals(FTBQLangConvert.originalLangCode)) {
                File questsFolder = new File(Constants.PackMCMeta.GAMEDIR, "config\\ftbquests\\quests\\");
                File parent = new File(Constants.PackMCMeta.GAMEDIR, "FTBLang");
                if (questsFolder.exists()) {
                    File backup = new File(parent, "backup\\ftbquests\\quests");
                    FileUtils.copyDirectory((File)questsFolder, (File)backup);
                }
            }
        }
        catch (IOException e) {
            log.info("This is first port!");
        }
    }

    @Override
    public void handleRewardTables(List<RewardTable> rewardTables) {
        rewardTables.forEach(rewardTable -> {
            try {
                rewardTable.setRawTitle(defaultJSON.get(rewardTable.getRawTitle().replaceAll("[{}]", "")).getAsString());
            }
            catch (Exception e) {
                try {
                    rewardTable.setRawTitle(enJson.get(rewardTable.getRawTitle().replaceAll("[{}]", "")).getAsString());
                }
                catch (Exception e1) {
                    log.info("rewardTable title is not in kubejs!");
                }
            }
        });
    }

    @Override
    public void handleChapterGroup(ChapterGroup chapterGroup) {
        if (chapterGroup.getRawTitle().contains("{")) {
            try {
                chapterGroup.setRawTitle(defaultJSON.get(chapterGroup.getRawTitle().replaceAll("[{}]", "")).getAsString());
            }
            catch (Exception e) {
                try {
                    chapterGroup.setRawTitle(enJson.get(chapterGroup.getRawTitle().replaceAll("[{}]", "")).getAsString());
                }
                catch (Exception e1) {
                    log.info("ChapterGroup title is not in kubejs!");
                }
            }
        }
    }

    @Override
    public void handleChapter(Chapter chapter) {
        try {
            if (chapter.getRawTitle().contains("{")) {
                try {
                    chapter.setRawTitle(defaultJSON.get(chapter.getRawTitle().replaceAll("[{}]", "")).getAsString());
                }
                catch (Exception e) {
                    try {
                        chapter.setRawTitle(enJson.get(chapter.getRawTitle().replaceAll("[{}]", "")).getAsString());
                    }
                    catch (Exception e1) {
                        log.info("chapter title is not in kubejs!");
                    }
                }
            }
            Field rawSubtitle = chapter.getClass().getDeclaredField("rawSubtitle");
            rawSubtitle.setAccessible(true);
            ArrayList subtitle = new ArrayList(chapterSubMap.get(chapter.id));
            ArrayList<String> subtitleList = new ArrayList<String>();
            for (String s : subtitle) {
                if (s.contains("{")) {
                    String key = s.replaceAll("[{}]", "");
                    try {
                        subtitleList.add(defaultJSON.get(key).getAsString());
                    }
                    catch (Exception e) {
                        try {
                            subtitleList.add(enJson.get(key).getAsString());
                        }
                        catch (Exception e1) {
                            log.info("chaptSubtitle is not in kubejs!");
                        }
                    }
                    continue;
                }
                subtitleList.add(s);
            }
            if (!subtitleList.isEmpty()) {
                rawSubtitle.set(chapter, subtitleList);
            }
            ArrayList images = new ArrayList(chapterImageList.get(chapter.id));
            Field hoverText = ChapterImage.class.getDeclaredField("hover");
            hoverText.setAccessible(true);
            long num = 0L;
            for (ChapterImage image : images) {
                try {
                    ArrayList chapterImageHoverTextList = new ArrayList();
                    List<String> hoverTextList = hoverTextMap.get(String.valueOf(chapter.id) + num);
                    ++num;
                    log.info(hoverTextList.toString());
                    if (hoverTextList.isEmpty()) continue;
                    hoverTextList.forEach(hoverTextString -> {
                        if (hoverTextString.contains("image.hovertext")) {
                            String key = hoverTextString.replaceAll("[{}]", "");
                            try {
                                chapterImageHoverTextList.add(defaultJSON.get(key).getAsString());
                            }
                            catch (Exception e) {
                                try {
                                    chapterImageHoverTextList.add(enJson.get(key).getAsString());
                                }
                                catch (Exception e1) {
                                    log.info("chapter ImageHoverText is not in kubejs!");
                                }
                            }
                        } else {
                            chapterImageHoverTextList.add(hoverTextString);
                        }
                    });
                    if (chapterImageHoverTextList.isEmpty()) continue;
                    hoverText.set(image, chapterImageHoverTextList);
                }
                catch (IllegalAccessException e) {
                    Narrator.LOGGER.info(e.getMessage());
                }
            }
            Field images1 = Chapter.class.getDeclaredField("images");
            images1.setAccessible(true);
            images1.set(chapter, images);
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
    }

    @Override
    public void handleQuests(List<Quest> allQuests) {
        allQuests.forEach(quest -> {
            if (quest.getRawTitle().contains("{")) {
                try {
                    quest.setRawTitle(defaultJSON.get(quest.getRawTitle().replaceAll("[{}]", "")).getAsString());
                }
                catch (Exception e) {
                    try {
                        quest.setRawTitle(enJson.get(quest.getRawTitle().replaceAll("[{}]", "")).getAsString());
                    }
                    catch (Exception e1) {
                        log.info("questTitle is not in kubejs!");
                    }
                }
            }
            if (quest.getRawSubtitle().contains("{")) {
                try {
                    quest.setRawSubtitle(defaultJSON.get(quest.getRawSubtitle().replaceAll("[{}]", "")).getAsString());
                }
                catch (Exception e) {
                    try {
                        quest.setRawSubtitle(enJson.get(quest.getRawSubtitle().replaceAll("[{}]", "")).getAsString());
                    }
                    catch (Exception e1) {
                        log.info("questSubtitle is not in kubejs!");
                    }
                }
            }
            try {
                quest.getRewards().stream().filter(reward -> !reward.getRawTitle().isEmpty() && reward.getRawTitle().contains("{")).forEach(reward -> reward.setRawTitle(defaultJSON.get(reward.getRawTitle().replaceAll("[{}]", "")).getAsString()));
            }
            catch (Exception e) {
                try {
                    quest.getRewards().stream().filter(reward -> !reward.getRawTitle().isEmpty() && reward.getRawTitle().contains("{")).forEach(reward -> reward.setRawTitle(enJson.get(reward.getRawTitle().replaceAll("[{}]", "")).getAsString()));
                }
                catch (Exception e1) {
                    log.info("questReward title is not in kubejs!");
                }
            }
            try {
                quest.getTasksAsList().stream().filter(task -> !task.getRawTitle().isEmpty() && task.getRawTitle().contains("{")).forEach(task -> task.setRawTitle(defaultJSON.get(task.getRawTitle().replaceAll("[{}]", "")).getAsString()));
            }
            catch (Exception e) {
                try {
                    quest.getTasksAsList().stream().filter(task -> !task.getRawTitle().isEmpty() && task.getRawTitle().contains("{")).forEach(task -> task.setRawTitle(enJson.get(task.getRawTitle().replaceAll("[{}]", "")).getAsString()));
                }
                catch (Exception e1) {
                    log.info("questReward title is not in kubejs!");
                }
            }
            this.handleQuestDescriptions(quest.id);
            quest.getRawDescription().clear();
            quest.getRawDescription().addAll(descList);
            descList.clear();
        });
    }

    private void handleQuestDescriptions(long id) {
        String rich_desc_regex = "\\s*[\\[{].*\"+.*[]}]\\s*";
        Pattern rich_desc_pattern = Pattern.compile(rich_desc_regex);
        ArrayList newDescList = new ArrayList(newdescMap.get(id));
        for (String s : newDescList) {
            if (s.isBlank()) {
                descList.add("");
            } else if (s.contains("{@pagebreak}")) {
                descList.add(s);
            }
            if (rich_desc_pattern.matcher(s).find()) {
                Pattern pattern = Pattern.compile("ftbquests\\.chapter\\.[a-zA-Z0-9_]+\\.quest\\d+\\.[a-zA-Z_]+description\\d");
                Matcher matcher = pattern.matcher(s);
                while (matcher.find()) {
                    try {
                        s = s.replace(matcher.group(0), defaultJSON.get(matcher.group(0)).getAsString()).replace("translate", "text").replace("%%", "%");
                    }
                    catch (Exception e) {
                        try {
                            s = s.replace(matcher.group(0), enJson.get(matcher.group(0)).getAsString()).replace("translate", "text").replace("%%", "%");
                        }
                        catch (Exception e1) {
                            log.info(e1.getMessage());
                        }
                    }
                }
                descList.add(s);
                continue;
            }
            if (s.contains("ftbquests")) {
                if (!s.contains("{")) continue;
                String key = s.replaceAll("[{}]", "");
                try {
                    descList.add(defaultJSON.get(key).getAsString().replace("%%", "%"));
                }
                catch (Exception e) {
                    try {
                        descList.add(enJson.get(key).getAsString().replace("%%", "%"));
                    }
                    catch (Exception e1) {
                        log.info(e1.getMessage());
                    }
                }
                continue;
            }
            if (s.isBlank() || s.contains("{@pagebreak}")) continue;
            descList.add(s);
        }
    }
}

