/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.levelpreview.lib;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.DeflaterOutputStream;
import net.creeperhost.ftbbackups.repack.net.covers1624.quack.util.SneakyUtils;

public class SimplePNG {
    private static final byte[] PNG_HEADER = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final byte[] IHDR = new byte[]{73, 72, 68, 82};
    private static final byte[] IDAT = new byte[]{73, 68, 65, 84};
    private static final byte[] tEXt = new byte[]{116, 69, 88, 116};
    private static final byte[] IEND = new byte[]{73, 69, 78, 68};
    private static final CRC32 CRC = new CRC32();

    public static void writePNG(Path file, SimpleImg img) throws IOException {
        SimplePNG.writePNG(Files.newOutputStream(file, new OpenOption[0]), img);
    }

    public static void writePNG(OutputStream os, SimpleImg img) throws IOException {
        try (DataOutputStream dos = new DataOutputStream(os);){
            dos.write(PNG_HEADER);
            SimplePNG.writeChunk(dos, IHDR, new byte[]{(byte)(img.width >> 24 & 0xFF), (byte)(img.width >> 16 & 0xFF), (byte)(img.width >> 8 & 0xFF), (byte)(img.width & 0xFF), (byte)(img.height >> 24 & 0xFF), (byte)(img.height >> 16 & 0xFF), (byte)(img.height >> 8 & 0xFF), (byte)(img.height & 0xFF), 8, 6, 0, 0, 0});
            if (!img.textTags.isEmpty()) {
                img.textTags.forEach((key, val) -> SneakyUtils.sneaky(() -> SimplePNG.writeChunk(dos, tEXt, (key + "\u0000" + val).getBytes(StandardCharsets.ISO_8859_1))));
            }
            SimplePNG.writeChunk(dos, IDAT, SimplePNG.compressData(img.pixels, img.width, img.height));
            SimplePNG.writeChunk(dos, IEND, new byte[0]);
        }
    }

    public static byte[] compressData(int[] pixels, int width, int height) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (DeflaterOutputStream dos = new DeflaterOutputStream(os);){
            for (int line = 0; line < height; ++line) {
                dos.write(0);
                for (int row = 0; row < width; ++row) {
                    int i = line * width + row;
                    dos.write(pixels[i] >> 16 & 0xFF);
                    dos.write(pixels[i] >> 8 & 0xFF);
                    dos.write(pixels[i] & 0xFF);
                    dos.write(pixels[i] >> 24 & 0xFF);
                }
            }
        }
        return os.toByteArray();
    }

    public static void writeChunk(DataOutputStream dos, byte[] type, byte[] data) throws IOException {
        dos.writeInt(data.length);
        dos.write(type);
        dos.write(data);
        CRC.reset();
        CRC.update(type, 0, type.length);
        CRC.update(data, 0, data.length);
        dos.writeInt((int)CRC.getValue());
    }

    public static int calculateNetworkByteOrderCRC32(int crc, byte[] data) {
        for (byte b : data) {
            crc ^= b & 0xFF;
            for (int i = 0; i < 8; ++i) {
                if ((crc & 1) == 1) {
                    crc = crc >>> 1 ^ 0xEDB88320;
                    continue;
                }
                crc >>>= 1;
            }
        }
        return crc;
    }

    public static class SimpleImg {
        private final int width;
        private final int height;
        private final int[] pixels;
        private final Map<String, String> textTags = new HashMap<String, String>();

        public SimpleImg(int width, int height) {
            this.width = width;
            this.height = height;
            this.pixels = new int[width * height];
        }

        public void set(int x, int y, int argb) {
            int i = y * this.width + x;
            this.pixels[i] = argb;
        }

        public int get(int x, int y) {
            int i = y * this.width + x;
            return this.pixels[i];
        }

        public void setTextTag(String key, String value) {
            this.textTags.put(key, value);
        }

        public Map<String, String> getTextTags() {
            return this.textTags;
        }
    }
}

