/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.network;

import com.mrcrayfish.framework.api.data.login.ILoginData;
import com.mrcrayfish.framework.network.message.handshake.S2CLoginData;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class LoginDataManager {
    private static final Map<ResourceLocation, Supplier<? extends ILoginData>> LOGIN_DATA = new ConcurrentHashMap<ResourceLocation, Supplier<? extends ILoginData>>();

    public static List<Pair<String, S2CLoginData>> getLoginDataMessages(boolean isLocal) {
        return LOGIN_DATA.entrySet().stream().map(entry -> {
            ResourceLocation id = (ResourceLocation)entry.getKey();
            ILoginData data = (ILoginData)((Supplier)entry.getValue()).get();
            FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
            data.writeData(buffer);
            return Pair.of((Object)id.toString(), (Object)new S2CLoginData(id, buffer));
        }).collect(Collectors.toList());
    }

    public static synchronized void registerLoginData(ResourceLocation id, Supplier<? extends ILoginData> data) {
        LOGIN_DATA.putIfAbsent(id, data);
    }

    public static Supplier<? extends ILoginData> getLoginDataSupplier(ResourceLocation id) {
        return LOGIN_DATA.get(id);
    }

    public static Map<ResourceLocation, Supplier<? extends ILoginData>> getLoginData() {
        return LOGIN_DATA;
    }
}

