/*
 * Decompiled with CFR 0.152.
 */
package com.moepus.flerovium.functions;

import com.moepus.flerovium.functions.MathUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import me.jellysquid.mods.sodium.client.model.color.interop.ItemColorsExtended;
import me.jellysquid.mods.sodium.client.model.quad.BakedQuadView;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.render.texture.SpriteUtil;
import net.caffeinemc.mods.sodium.api.math.MatrixHelper;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.api.util.NormI8;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.common.ModelVertex;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class FastSimpleBakedModelRenderer {
    private static final MemoryStack STACK = MemoryStack.create();
    private static final int VERTEX_COUNT = 4;
    private static final int BUFFER_VERTEX_COUNT = 48;
    private static final int STRIDE = 8;
    private static final long SCRATCH_BUFFER;
    private static long BUFFER_PTR;
    private static int BUFFED_VERTEX;
    private static int LAST_TINT_INDEX;
    private static int LAST_TINT;

    public static int multiplyIntBytes(int a, int b) {
        int first = ((a & 0xFF) * (b & 0xFF) + 127) / 255;
        int second = ((a >>> 8 & 0xFF) * (b >>> 8 & 0xFF) + 127) / 255;
        int third = ((a >>> 16 & 0xFF) * (b >>> 16 & 0xFF) + 127) / 255;
        return first | second << 8 | third << 16 | b & 0xFF000000;
    }

    private static void flush(VertexBufferWriter writer) {
        if (BUFFED_VERTEX == 0) {
            return;
        }
        STACK.push();
        writer.push(STACK, SCRATCH_BUFFER, BUFFED_VERTEX, ModelVertex.FORMAT);
        STACK.pop();
        BUFFER_PTR = SCRATCH_BUFFER;
        BUFFED_VERTEX = 0;
    }

    private static boolean isBufferMax() {
        return BUFFED_VERTEX >= 48;
    }

    private static boolean checkNormalRotateEqual(PoseStack.Pose pose) {
        return ((Float.floatToRawIntBits(pose.m_252922_().m00()) ^ Float.floatToRawIntBits(pose.m_252943_().m00())) >> 31) + ((Float.floatToRawIntBits(pose.m_252922_().m10()) ^ Float.floatToRawIntBits(pose.m_252943_().m10())) >> 31) + ((Float.floatToRawIntBits(pose.m_252922_().m20()) ^ Float.floatToRawIntBits(pose.m_252943_().m20())) >> 31) == 0;
    }

    private static void putBulkData(VertexBufferWriter writer, PoseStack.Pose pose, BakedQuad bakedQuad, int light, int overlay, int color, int faces) {
        int[] vertices = bakedQuad.m_111303_();
        if (vertices.length != 32) {
            return;
        }
        Matrix4f pose_matrix = pose.m_252922_();
        int baked_normal = vertices[7];
        float unpackedX = NormI8.unpackX((int)baked_normal);
        float unpackedY = NormI8.unpackY((int)baked_normal);
        float unpackedZ = NormI8.unpackZ((int)baked_normal);
        float nx = MatrixHelper.transformNormalX((Matrix3f)pose.m_252943_(), (float)unpackedX, (float)unpackedY, (float)unpackedZ);
        float ny = MatrixHelper.transformNormalY((Matrix3f)pose.m_252943_(), (float)unpackedX, (float)unpackedY, (float)unpackedZ);
        float nz = MatrixHelper.transformNormalZ((Matrix3f)pose.m_252943_(), (float)unpackedX, (float)unpackedY, (float)unpackedZ);
        float x = Float.intBitsToFloat(vertices[0]);
        float y = Float.intBitsToFloat(vertices[1]);
        float z = Float.intBitsToFloat(vertices[2]);
        float pos0_x = MatrixHelper.transformPositionX((Matrix4f)pose_matrix, (float)x, (float)y, (float)z);
        float pos0_y = MatrixHelper.transformPositionY((Matrix4f)pose_matrix, (float)x, (float)y, (float)z);
        float pos0_z = MatrixHelper.transformPositionZ((Matrix4f)pose_matrix, (float)x, (float)y, (float)z);
        x = Float.intBitsToFloat(vertices[16]);
        y = Float.intBitsToFloat(vertices[17]);
        z = Float.intBitsToFloat(vertices[18]);
        float pos2_x = MatrixHelper.transformPositionX((Matrix4f)pose_matrix, (float)x, (float)y, (float)z);
        float pos2_y = MatrixHelper.transformPositionY((Matrix4f)pose_matrix, (float)x, (float)y, (float)z);
        float pos2_z = MatrixHelper.transformPositionZ((Matrix4f)pose_matrix, (float)x, (float)y, (float)z);
        if ((faces & 0x40) != 0 && FastSimpleBakedModelRenderer.checkNormalRotateEqual(pose) && (pos0_x + pos2_x) * nx + (pos0_y + pos2_y) * ny + (pos0_z + pos2_z) * nz > 0.0f && ((BakedQuadView)bakedQuad).getNormalFace() != ModelQuadFacing.UNASSIGNED) {
            return;
        }
        int n = MathUtil.packSafe(nx, ny, nz);
        x = Float.intBitsToFloat(vertices[8]);
        y = Float.intBitsToFloat(vertices[9]);
        z = Float.intBitsToFloat(vertices[10]);
        float pos1_x = MatrixHelper.transformPositionX((Matrix4f)pose_matrix, (float)x, (float)y, (float)z);
        float pos1_y = MatrixHelper.transformPositionY((Matrix4f)pose_matrix, (float)x, (float)y, (float)z);
        float pos1_z = MatrixHelper.transformPositionZ((Matrix4f)pose_matrix, (float)x, (float)y, (float)z);
        x = Float.intBitsToFloat(vertices[24]);
        y = Float.intBitsToFloat(vertices[25]);
        z = Float.intBitsToFloat(vertices[26]);
        float pos3_x = MatrixHelper.transformPositionX((Matrix4f)pose_matrix, (float)x, (float)y, (float)z);
        float pos3_y = MatrixHelper.transformPositionY((Matrix4f)pose_matrix, (float)x, (float)y, (float)z);
        float pos3_z = MatrixHelper.transformPositionZ((Matrix4f)pose_matrix, (float)x, (float)y, (float)z);
        int c = color != -1 ? FastSimpleBakedModelRenderer.multiplyIntBytes(color, vertices[3]) : vertices[3];
        int baked = vertices[6];
        int l = Math.max((int)((baked & 0xFFFF) << 16 | baked >> 16), (int)light);
        ModelVertex.write((long)BUFFER_PTR, (float)pos0_x, (float)pos0_y, (float)pos0_z, (int)c, (float)Float.intBitsToFloat(vertices[4]), (float)Float.intBitsToFloat(vertices[5]), (int)overlay, (int)l, (int)n);
        ModelVertex.write((long)(BUFFER_PTR += 36L), (float)pos1_x, (float)pos1_y, (float)pos1_z, (int)c, (float)Float.intBitsToFloat(vertices[12]), (float)Float.intBitsToFloat(vertices[13]), (int)overlay, (int)l, (int)n);
        ModelVertex.write((long)(BUFFER_PTR += 36L), (float)pos2_x, (float)pos2_y, (float)pos2_z, (int)c, (float)Float.intBitsToFloat(vertices[20]), (float)Float.intBitsToFloat(vertices[21]), (int)overlay, (int)l, (int)n);
        ModelVertex.write((long)(BUFFER_PTR += 36L), (float)pos3_x, (float)pos3_y, (float)pos3_z, (int)c, (float)Float.intBitsToFloat(vertices[28]), (float)Float.intBitsToFloat(vertices[29]), (int)overlay, (int)l, (int)n);
        BUFFER_PTR += 36L;
        BUFFED_VERTEX += 4;
        if (FastSimpleBakedModelRenderer.isBufferMax()) {
            FastSimpleBakedModelRenderer.flush(writer);
        }
    }

    public static int GetItemTint(int tintIndex, ItemStack itemStack, ItemColor colorProvider) {
        if (tintIndex == LAST_TINT_INDEX) {
            return LAST_TINT;
        }
        int tint = colorProvider.m_92671_(itemStack, tintIndex);
        LAST_TINT = ColorARGB.toABGR((int)tint, (int)255);
        LAST_TINT_INDEX = tintIndex;
        return LAST_TINT;
    }

    private static void renderQuadList(PoseStack.Pose pose, VertexBufferWriter writer, int faces, List<BakedQuad> bakedQuads, int light, int overlay, ItemStack itemStack, ItemColor colorProvider) {
        for (BakedQuad bakedQuad : bakedQuads) {
            if ((faces & 1 << bakedQuad.m_111306_().ordinal()) == 0) continue;
            int color = colorProvider != null && bakedQuad.m_111305_() != -1 ? FastSimpleBakedModelRenderer.GetItemTint(bakedQuad.m_111305_(), itemStack, colorProvider) : -1;
            FastSimpleBakedModelRenderer.putBulkData(writer, pose, bakedQuad, light, overlay, color, faces);
        }
        if (pose.m_252922_().m32() > -8.0f) {
            for (BakedQuad bakedQuad : bakedQuads) {
                SpriteUtil.markSpriteActive((TextureAtlasSprite)bakedQuad.m_173410_());
            }
        }
    }

    public static void render(SimpleBakedModel model, int faces, ItemStack itemStack, int packedLight, int packedOverlay, PoseStack poseStack, VertexBufferWriter writer, ItemColors itemColors) {
        PoseStack.Pose pose = poseStack.m_85850_();
        ItemColor colorProvider = !itemStack.m_41619_() ? ((ItemColorsExtended)itemColors).sodium$getColorProvider(itemStack) : null;
        LAST_TINT = -1;
        LAST_TINT_INDEX = -1;
        for (Direction direction : Direction.values()) {
            FastSimpleBakedModelRenderer.renderQuadList(pose, writer, faces, model.m_213637_(null, direction, null), packedLight, packedOverlay, itemStack, colorProvider);
        }
        FastSimpleBakedModelRenderer.renderQuadList(pose, writer, faces, model.m_213637_(null, null, null), packedLight, packedOverlay, itemStack, colorProvider);
        FastSimpleBakedModelRenderer.flush(writer);
    }

    static {
        BUFFER_PTR = SCRATCH_BUFFER = MemoryUtil.nmemAlignedAlloc((long)64L, (long)1728L);
        BUFFED_VERTEX = 0;
        LAST_TINT_INDEX = -1;
        LAST_TINT = -1;
    }
}

