/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.common.block.furniture;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.apexcore.lib.block.BaseBlock;
import xyz.apex.forge.fantasyfurniture.AllBlockEntities;
import xyz.apex.forge.fantasyfurniture.AllBlocks;
import xyz.apex.forge.fantasyfurniture.AllMenus;
import xyz.apex.forge.fantasyfurniture.common.block.entity.OvenBlockEntity;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.IDyeable;
import xyz.apex.forge.fantasyfurniture.common.menu.OvenMenu;
import xyz.apex.forge.fantasyfurniture.core.HitBoxes;

public class OvenBlock
extends BaseBlock.WithContainer<OvenBlockEntity, OvenMenu> {
    public OvenBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)));
    }

    protected MenuType<OvenMenu> getContainerType() {
        return (MenuType)AllMenus.OVEN_MENU.get();
    }

    protected BlockEntityType<OvenBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntities.OVEN_BLOCK_ENTITY.get();
    }

    protected void registerProperties(Consumer<Property<?>> consumer) {
        super.registerProperties(consumer);
        consumer.accept((Property<?>)FACING_4_WAY);
        consumer.accept((Property<?>)WATERLOGGED);
        consumer.accept((Property<?>)BlockStateProperties.f_61443_);
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos pos, BlockState newBlockState, boolean isMoving) {
        if (!blockState.m_60713_(newBlockState.m_60734_()) && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            OvenBlockEntity blockEntity = (OvenBlockEntity)this.getBlockEntity(blockState, (BlockGetter)level, pos);
            if (blockEntity != null) {
                blockEntity.awardRecipesAndExperience(serverLevel, null, Vec3.m_82512_((Vec3i)pos));
            }
        }
        super.m_6810_(blockState, level, pos, newBlockState, isMoving);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        if (AllBlocks.NORDIC_OVEN.isIn(blockState)) {
            return HitBoxes.NORDIC.oven((Block)this, blockState);
        }
        if (AllBlocks.VENTHYR_OVEN.isIn(blockState)) {
            return HitBoxes.VENTHYR.oven((Block)this, blockState);
        }
        if (AllBlocks.BONE_SKELETON_OVEN.isIn(blockState) || AllBlocks.BONE_WITHER_PAINTING_WIDE.isIn(blockState)) {
            return HitBoxes.BONE.oven((Block)this, blockState);
        }
        if (AllBlocks.ROYAL_OVEN.isIn(blockState)) {
            return HitBoxes.ROYAL.oven((Block)this, blockState);
        }
        if (AllBlocks.NECROLORD_OVEN.isIn(blockState)) {
            return HitBoxes.NECROLORD.oven((Block)this, blockState);
        }
        return super.m_5940_(blockState, level, pos, ctx);
    }

    @Nullable
    protected BlockEntityTicker<OvenBlockEntity> getBlockEntityTicker(boolean clientSide) {
        return clientSide ? null : (level, pos, blockState, blockEntity) -> blockEntity.serverTick(level, pos, blockState);
    }

    public static class Dyeable
    extends OvenBlock
    implements IDyeable {
        public Dyeable(BlockBehaviour.Properties properties) {
            super(properties);
            this.m_49959_(IDyeable.registerDefaultBlockState(this.m_49966_()));
        }

        public MapColor getMapColor(BlockState blockState, BlockGetter level, BlockPos pos, MapColor defaultColor) {
            MapColor color = super.getMapColor(blockState, level, pos, defaultColor);
            return IDyeable.getDyedMapColor(blockState, level, pos, color);
        }

        @Override
        protected void registerProperties(Consumer<Property<?>> consumer) {
            super.registerProperties(consumer);
            IDyeable.registerProperties(consumer);
        }

        @Nullable
        protected BlockState modifyPlacementState(BlockState placementBlockState, BlockPlaceContext ctx) {
            placementBlockState = super.modifyPlacementState(placementBlockState, ctx);
            return IDyeable.getStateForPlacement(ctx, placementBlockState);
        }

        public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
            InteractionResult interactionResult = IDyeable.use(blockState, level, pos, player, hand);
            if (interactionResult.m_19077_()) {
                return interactionResult;
            }
            return super.m_6227_(blockState, level, pos, player, hand, result);
        }

        public ItemStack getCloneItemStack(BlockState blockState, HitResult target, BlockGetter level, BlockPos pos, Player player) {
            ItemStack stack = super.getCloneItemStack(blockState, target, level, pos, player);
            return IDyeable.getCloneItemStack(blockState, level, pos, stack);
        }

        public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
            super.m_5871_(stack, level, tooltip, flag);
            IDyeable.appendHoverText(this, tooltip);
        }
    }
}

