/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.resource;

import de.keksuccino.fancymenu.util.CloseableUtils;
import de.keksuccino.fancymenu.util.file.GameDirectoryUtils;
import de.keksuccino.fancymenu.util.file.type.FileType;
import de.keksuccino.fancymenu.util.resource.Resource;
import de.keksuccino.fancymenu.util.resource.ResourceSource;
import de.keksuccino.fancymenu.util.resource.ResourceSourceType;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourceHandler<R extends Resource, F extends FileType<R>> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected Map<String, R> resources = new HashMap<String, R>();
    protected List<String> failedSources = new ArrayList<String>();

    @Nullable
    public R get(@NotNull String resourceSource) {
        Objects.requireNonNull(resourceSource);
        return this.get(ResourceSource.of(resourceSource));
    }

    @Nullable
    public R get(@NotNull ResourceSource resourceSource) {
        Objects.requireNonNull(resourceSource);
        try {
            R registered = this.getFromMapAndClearClosed(resourceSource.getSourceWithPrefix());
            if (registered != null) {
                return registered;
            }
            if (this.getFailedSourcesList().contains(resourceSource.getSourceWithPrefix())) {
                return null;
            }
            FileType fileType = null;
            for (FileType type : this.getAllowedFileTypes()) {
                if (!type.isFileType(resourceSource, false)) continue;
                fileType = type;
                break;
            }
            if (fileType == null && resourceSource.getSourceType() == ResourceSourceType.WEB) {
                for (FileType type : this.getAllowedFileTypes()) {
                    if (!type.isFileTypeWebAdvanced(resourceSource.getSourceWithoutPrefix())) continue;
                    fileType = type;
                    break;
                }
            }
            if (fileType == null) {
                fileType = (FileType)this.getFallbackFileType();
            }
            if (fileType == null) {
                LOGGER.error("[FANCYMENU] Failed to register resource! Unsupported file type or failed to identify file type: " + String.valueOf(resourceSource) + " (RESOURCE HANDLER: " + String.valueOf(this.getClass()) + ")");
                this.addToFailedSources(resourceSource);
                return null;
            }
            if (resourceSource.getSourceType() == ResourceSourceType.WEB) {
                if (!fileType.isWebAllowed()) {
                    LOGGER.error("[FANCYMENU] Failed to register web resource! File type does not support web sources: " + String.valueOf(fileType) + " (Source: " + String.valueOf(resourceSource) + ") (RESOURCE HANDLER: " + String.valueOf(this.getClass()) + ")");
                    this.addToFailedSources(resourceSource);
                    return null;
                }
                return (R)this.putAndReturn((Resource)fileType.getCodec().readWeb(resourceSource.getSourceWithoutPrefix()), resourceSource);
            }
            if (resourceSource.getSourceType() == ResourceSourceType.LOCATION) {
                if (!fileType.isLocationAllowed()) {
                    LOGGER.error("[FANCYMENU] Failed to register location resource! File type does not support location sources: " + String.valueOf(fileType) + " (Source: " + String.valueOf(resourceSource) + ") (RESOURCE HANDLER: " + String.valueOf(this.getClass()) + ")");
                    this.addToFailedSources(resourceSource);
                    return null;
                }
                ResourceLocation loc = ResourceLocation.m_135820_((String)resourceSource.getSourceWithoutPrefix());
                if (loc == null) {
                    LOGGER.error("[FANCYMENU] Failed to register location resource! Unable to parse ResourceLocation: " + String.valueOf(resourceSource) + " (RESOURCE HANDLER: " + String.valueOf(this.getClass()) + ")");
                    this.addToFailedSources(resourceSource);
                    return null;
                }
                return (R)this.putAndReturn((Resource)fileType.getCodec().readLocation(loc), resourceSource);
            }
            if (!fileType.isLocalAllowed()) {
                LOGGER.error("[FANCYMENU] Failed to register local resource! File type does not support local sources: " + String.valueOf(fileType) + " (Source: " + String.valueOf(resourceSource) + ") (RESOURCE HANDLER: " + String.valueOf(this.getClass()) + ")");
                this.addToFailedSources(resourceSource);
                return null;
            }
            return (R)this.putAndReturn((Resource)fileType.getCodec().readLocal(new File(resourceSource.getSourceWithoutPrefix())), resourceSource);
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to register resource: " + String.valueOf(resourceSource) + " (RESOURCE HANDLER: " + String.valueOf(this.getClass()) + ")", (Throwable)ex);
            this.addToFailedSources(resourceSource);
            return null;
        }
    }

    @Nullable
    public R getIfRegistered(@NotNull String key) {
        return (R)((Resource)this.getResourceMap().get(Objects.requireNonNull(key)));
    }

    public void registerIfKeyAbsent(@NotNull String key, @NotNull R resource) {
        if (!this.hasResource(key)) {
            LOGGER.debug("[FANCYMENU] Registering resource with key: " + key + " (RESOURCE HANDLER: " + String.valueOf(this.getClass()) + ")");
            this.getResourceMap().put(key, (Resource)Objects.requireNonNull(resource));
        }
    }

    public boolean hasResource(@NotNull String key) {
        return this.getResourceMap().containsKey(Objects.requireNonNull(key));
    }

    @Nullable
    protected R getFromMapAndClearClosed(@Nullable String resourceSource) {
        if (resourceSource == null) {
            return null;
        }
        if (this.getResourceMap().containsKey(resourceSource)) {
            Resource resource = (Resource)this.getResourceMap().get(resourceSource);
            if (resource.isClosed()) {
                CloseableUtils.closeQuietly(resource);
                this.getResourceMap().remove(resourceSource);
            } else {
                return (R)resource;
            }
        }
        return null;
    }

    @Nullable
    protected R putAndReturn(@Nullable R resource, @NotNull ResourceSource resourceSource) {
        Objects.requireNonNull(resourceSource);
        if (resource != null) {
            LOGGER.debug("[FANCYMENU] Registering resource with source: " + String.valueOf(resourceSource) + " (RESOURCE HANDLER: " + String.valueOf(this.getClass()) + ")");
            this.getResourceMap().put(resourceSource.getSourceWithPrefix(), resource);
        } else if (!this.getFailedSourcesList().contains(resourceSource.getSourceWithPrefix())) {
            this.getFailedSourcesList().add(resourceSource.getSourceWithPrefix());
            LOGGER.error("[FANCYMENU] Failed to register resource! Resource was NULL: " + String.valueOf(resourceSource) + " (RESOURCE HANDLER: " + String.valueOf(this.getClass()) + ")");
        }
        return resource;
    }

    protected void addToFailedSources(@NotNull ResourceSource resourceSource) {
        if (!this.getFailedSourcesList().contains(resourceSource.getSourceWithPrefix())) {
            this.getFailedSourcesList().add(resourceSource.getSourceWithPrefix());
        }
    }

    @NotNull
    protected Map<String, R> getResourceMap() {
        return this.resources;
    }

    @NotNull
    protected List<String> getFailedSourcesList() {
        return this.failedSources;
    }

    @NotNull
    public abstract List<F> getAllowedFileTypes();

    @Nullable
    public abstract F getFallbackFileType();

    public void release(@NotNull String key, boolean isKeyResourceSource) {
        Resource resource;
        Objects.requireNonNull(key);
        if (isKeyResourceSource) {
            String finalKey = key;
            this.getFailedSourcesList().removeIf(s -> s.equals(finalKey));
            ResourceSourceType sourceType = ResourceSourceType.getSourceTypeOf((String)key);
            if (sourceType == ResourceSourceType.LOCAL) {
                key = GameDirectoryUtils.getAbsoluteGameDirectoryPath(ResourceSourceType.getWithoutSourcePrefix((String)key));
                key = sourceType.getSourcePrefix() + (String)key;
            }
        }
        if ((resource = (Resource)this.getResourceMap().get(key)) != null) {
            CloseableUtils.closeQuietly(resource);
        }
        this.getResourceMap().remove(key);
    }

    public void release(@NotNull R resource) {
        Objects.requireNonNull(resource);
        String key = null;
        for (Map.Entry<String, R> m : this.getResourceMap().entrySet()) {
            if (m.getValue() != resource) continue;
            key = m.getKey();
            break;
        }
        CloseableUtils.closeQuietly(resource);
        if (key != null) {
            this.getResourceMap().remove(key);
        }
    }

    public void releaseAll() {
        this.getResourceMap().values().forEach(CloseableUtils::closeQuietly);
        this.getResourceMap().clear();
        this.getFailedSourcesList().clear();
    }
}

