/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.networking.packets.commands.variable.command;

import de.keksuccino.fancymenu.customization.variables.VariableHandler;
import de.keksuccino.fancymenu.networking.packets.commands.variable.command.VariableCommandPacket;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ClientSideVariableCommandPacketLogic {
    private static final Logger LOGGER = LogManager.getLogger();

    protected static boolean handle(@NotNull VariableCommandPacket packet) {
        if (packet.set) {
            return ClientSideVariableCommandPacketLogic.setVariable(packet);
        }
        return ClientSideVariableCommandPacketLogic.getVariable(packet);
    }

    protected static boolean getVariable(@NotNull VariableCommandPacket packet) {
        try {
            String s;
            String string = s = VariableHandler.variableExists(Objects.requireNonNull(packet.variable_name)) ? Objects.requireNonNull(VariableHandler.getVariable(packet.variable_name)).getValue() : null;
            if (s != null) {
                packet.sendChatFeedback(Component.m_237110_((String)"fancymenu.commands.variable.get.success", (Object[])new Object[]{s}), false);
                return true;
            }
            packet.sendChatFeedback(Component.m_237115_((String)"fancymenu.commands.variable.not_found"), true);
        }
        catch (Exception ex) {
            packet.sendChatFeedback(Component.m_237115_((String)"fancymenu.commands.variable.get.error"), true);
            LOGGER.error("[FANCYMENU] Failed to get variable via /fmvariable command!", (Throwable)ex);
        }
        return false;
    }

    protected static boolean setVariable(@NotNull VariableCommandPacket packet) {
        try {
            VariableHandler.setVariable(Objects.requireNonNull(packet.variable_name), Objects.requireNonNull(packet.set_to_value));
            if (packet.feedback) {
                packet.sendChatFeedback(Component.m_237110_((String)"fancymenu.commands.variable.set.success", (Object[])new Object[]{packet.set_to_value}), false);
            }
            return true;
        }
        catch (Exception ex) {
            packet.sendChatFeedback(Component.m_237115_((String)"fancymenu.commands.variable.set.error"), true);
            LOGGER.error("[FANCYMENU] Failed to set variable via /fmvariable command!", (Throwable)ex);
            return false;
        }
    }
}

