/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout;

import com.google.common.io.Files;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.layout.Layout;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.customization.screen.identifier.ScreenIdentifierHandler;
import de.keksuccino.fancymenu.util.ListUtils;
import de.keksuccino.fancymenu.util.file.FileUtils;
import de.keksuccino.fancymenu.util.file.FilenameComparator;
import de.keksuccino.fancymenu.util.properties.PropertiesParser;
import de.keksuccino.fancymenu.util.properties.PropertyContainerSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final File LAYOUT_DIR = FileUtils.createDirectory(new File(FancyMenu.MOD_DIR, "/customization"));
    public static final File ASSETS_DIR = FileUtils.createDirectory(new File(FancyMenu.MOD_DIR, "/assets"));
    private static final List<Layout> LAYOUTS = new ArrayList<Layout>();
    private static final Map<String, UniversalLayoutInclusionRule> UNIVERSAL_LAYOUT_INCLUSION_RULES = new HashMap<String, UniversalLayoutInclusionRule>();

    public static void init() {
        LayoutHandler.convertLegacyDisabledLayouts();
        LayoutHandler.reloadLayouts();
        for (Layout l : LAYOUTS) {
            if (!l.legacyLayout) continue;
            LOGGER.info("[FANCYMENU] Converting legacy (FMv2) layout '" + l.getLayoutName() + "' to new format..");
            if (l.saveToFileIfPossible()) continue;
            LOGGER.error("[FANCYMENU] Failed to convert legacy layout '" + l.getLayoutName() + "' to new format!");
        }
    }

    public static void reloadLayouts() {
        ScreenCustomization.readCustomizableScreensFromFile();
        List<Layout> layouts = LayoutHandler.deserializeLayoutFilesInDirectory(LAYOUT_DIR);
        LAYOUTS.clear();
        LAYOUTS.addAll(layouts);
    }

    @NotNull
    public static List<Layout> deserializeLayoutFilesInDirectory(File directory) {
        File[] filesArray;
        ArrayList<Layout> layouts = new ArrayList<Layout>();
        if (!directory.exists()) {
            directory.mkdirs();
        }
        if ((filesArray = directory.listFiles()) != null) {
            for (File f : filesArray) {
                Layout layout;
                PropertyContainerSet s;
                if (!f.getPath().toLowerCase().endsWith(".txt") || (s = PropertiesParser.deserializeSetFromFile(f.getAbsolutePath().replace("\\", "/"))) == null || (layout = LayoutHandler.deserializeLayout(s, f)) == null) continue;
                layouts.add(layout);
            }
        }
        return layouts;
    }

    @Nullable
    public static Layout deserializeLayout(@NotNull PropertyContainerSet serialized, @Nullable File layoutFile) {
        return Layout.deserialize(serialized, layoutFile);
    }

    public static boolean isLayoutLoaded(@NotNull String runtimeLayoutIdentifier) {
        for (Layout layout : LAYOUTS) {
            if (!layout.runtimeLayoutIdentifier.equals(runtimeLayoutIdentifier)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<Layout> getEnabledLayouts() {
        ArrayList<Layout> enabled = new ArrayList<Layout>();
        LAYOUTS.forEach(layout -> {
            if (layout.isEnabled()) {
                enabled.add((Layout)layout);
            }
        });
        return enabled;
    }

    @NotNull
    public static List<Layout> getDisabledLayouts() {
        ArrayList<Layout> disabled = new ArrayList<Layout>();
        LAYOUTS.forEach(layout -> {
            if (!layout.isEnabled()) {
                disabled.add((Layout)layout);
            }
        });
        return disabled;
    }

    @NotNull
    public static List<Layout> getAllLayouts() {
        return new ArrayList<Layout>(LAYOUTS);
    }

    @NotNull
    public static List<Layout> getEnabledLayoutsForScreenIdentifier(@NotNull String screenIdentifier, boolean includeUniversalLayouts) {
        for (UniversalLayoutInclusionRule universalLayoutInclusionRule : UNIVERSAL_LAYOUT_INCLUSION_RULES.values()) {
            if (universalLayoutInclusionRule.includeUniversalLayouts(screenIdentifier)) continue;
            includeUniversalLayouts = false;
            break;
        }
        ArrayList<Layout> layouts = new ArrayList<Layout>();
        for (Layout layout : LayoutHandler.getEnabledLayouts()) {
            if (ScreenIdentifierHandler.equalIdentifiers(screenIdentifier, layout.screenIdentifier)) {
                layouts.add(layout);
                continue;
            }
            if (!layout.isUniversalLayout() || !includeUniversalLayouts) continue;
            if (!layout.universalLayoutMenuWhitelist.isEmpty() || !layout.universalLayoutMenuBlacklist.isEmpty()) {
                if (!layout.universalLayoutMenuWhitelist.isEmpty() && layout.universalLayoutMenuWhitelist.contains(screenIdentifier)) {
                    layouts.add(layout);
                    continue;
                }
                if (layout.universalLayoutMenuBlacklist.isEmpty() || layout.universalLayoutMenuBlacklist.contains(screenIdentifier)) continue;
                layouts.add(layout);
                continue;
            }
            layouts.add(layout);
        }
        layouts.sort(Comparator.comparingInt(value -> value.layoutIndex));
        if (includeUniversalLayouts) {
            ArrayList<Layout> arrayList = new ArrayList<Layout>();
            ArrayList<Layout> universal = new ArrayList<Layout>();
            for (Layout layout : layouts) {
                if (layout.isUniversalLayout()) {
                    universal.add(layout);
                    continue;
                }
                arrayList.add(layout);
            }
            layouts.clear();
            layouts.addAll(universal);
            layouts.addAll(arrayList);
        }
        return layouts;
    }

    @NotNull
    public static List<Layout> getDisabledLayoutsForScreenIdentifier(@NotNull String screenIdentifier) {
        ArrayList<Layout> l = new ArrayList<Layout>();
        for (Layout layout : LayoutHandler.getDisabledLayouts()) {
            if (!ScreenIdentifierHandler.equalIdentifiers(screenIdentifier, layout.screenIdentifier)) continue;
            l.add(layout);
        }
        return l;
    }

    @NotNull
    public static List<Layout> getAllLayoutsForScreenIdentifier(@NotNull String screenIdentifier, boolean includeUniversalLayouts) {
        return ListUtils.mergeLists(LayoutHandler.getEnabledLayoutsForScreenIdentifier(screenIdentifier, includeUniversalLayouts), LayoutHandler.getDisabledLayoutsForScreenIdentifier(screenIdentifier));
    }

    @Nullable
    public static Layout getLayout(String name) {
        for (Layout l : LAYOUTS) {
            if (!l.getLayoutName().equals(name)) continue;
            return l;
        }
        return null;
    }

    @NotNull
    public static List<Layout> sortLayoutListByLastEdited(@NotNull List<Layout> layouts, boolean removeNeverEdited) {
        layouts.sort(Comparator.comparingLong(value -> value.lastEditedTime));
        Collections.reverse(layouts);
        if (removeNeverEdited) {
            layouts.removeIf(l -> l.lastEditedTime == -1L);
        }
        return layouts;
    }

    @NotNull
    public static List<Layout> sortLayoutListByLastEdited(@NotNull List<Layout> layouts, boolean removeNeverEdited, int maxLayouts) {
        LayoutHandler.sortLayoutListByLastEdited(layouts, removeNeverEdited);
        if (!layouts.isEmpty()) {
            ArrayList<Layout> temp = new ArrayList<Layout>(layouts.subList(0, Math.min(maxLayouts, layouts.size())));
            layouts.clear();
            layouts.addAll(temp);
        }
        return layouts;
    }

    @NotNull
    public static List<Layout> sortLayoutListByName(@NotNull List<Layout> layouts) {
        FilenameComparator comp = new FilenameComparator();
        layouts.sort((o1, o2) -> comp.compare(o1.getLayoutName(), o2.getLayoutName()));
        return layouts;
    }

    @NotNull
    public static List<Layout> sortLayoutListByStatus(@NotNull List<Layout> layouts, boolean disabledFirst) {
        LayoutHandler.sortLayoutListByName(layouts);
        ArrayList enabled = new ArrayList();
        ArrayList disabled = new ArrayList();
        layouts.forEach(layout -> {
            if (layout.isEnabled()) {
                enabled.add(layout);
            } else {
                disabled.add(layout);
            }
        });
        layouts.clear();
        if (disabledFirst) {
            layouts.addAll(disabled);
            layouts.addAll(enabled);
        } else {
            layouts.addAll(enabled);
            layouts.addAll(disabled);
        }
        return layouts;
    }

    public static void deleteLayout(@NotNull Layout layout, boolean reInitCurrentScreen) {
        try {
            if (layout.layoutFile != null) {
                layout.layoutFile.delete();
            }
            LAYOUTS.remove(layout);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (reInitCurrentScreen) {
            ScreenCustomization.reInitCurrentScreen();
        }
    }

    public static void addLayout(@NotNull Layout layout, boolean saveToFile) {
        if (!LAYOUTS.contains(layout)) {
            LAYOUTS.add(layout);
            if (saveToFile) {
                layout.saveToFileIfPossible();
            }
        }
    }

    public static void openLayoutEditor(@NotNull Layout layout, @Nullable Screen layoutTargetScreen) {
        try {
            Minecraft.m_91087_().m_91152_((Screen)new LayoutEditorScreen(layoutTargetScreen, layout).setAsCurrentInstance());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean saveLayoutToFile(Layout layout, String saveTo) {
        if (layout.screenIdentifier == null) {
            return false;
        }
        File f = new File(saveTo);
        if (f.isFile()) {
            f.delete();
        }
        PropertyContainerSet set = layout.serialize();
        PropertiesParser.serializeSetToFile(set, f.getPath());
        return true;
    }

    private static void convertLegacyDisabledLayouts() {
        File disabledDir = new File(LAYOUT_DIR.getPath() + "/.disabled");
        if (disabledDir.isDirectory()) {
            List<Layout> legacyDisabled = LayoutHandler.deserializeLayoutFilesInDirectory(disabledDir);
            for (Layout l : legacyDisabled) {
                try {
                    if (l.layoutFile == null) continue;
                    String name = FileUtils.generateAvailableFilename((String)LAYOUT_DIR.getPath(), (String)Files.getNameWithoutExtension((String)l.layoutFile.getPath()), (String)"txt");
                    File newFile = new File(LAYOUT_DIR.getPath() + "/" + name);
                    FileUtils.copyFile((File)l.layoutFile, (File)newFile);
                    l.layoutFile.delete();
                    l.layoutFile = newFile;
                    l.enabled = false;
                    l.saveToFileIfPossible();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    @NotNull
    public static String registerUniversalLayoutInclusionRule(@NotNull UniversalLayoutInclusionRule rule) {
        String id = ScreenCustomization.generateUniqueIdentifier();
        UNIVERSAL_LAYOUT_INCLUSION_RULES.put(id, rule);
        return id;
    }

    public static void unregisterUniversalLayoutInclusionRule(@NotNull String identifier) {
        UNIVERSAL_LAYOUT_INCLUSION_RULES.remove(identifier);
    }

    @FunctionalInterface
    public static interface UniversalLayoutInclusionRule {
        public boolean includeUniversalLayouts(@NotNull String var1);
    }
}

