/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.gameintro;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenCompletedEvent;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenEvent;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenStartingEvent;
import de.keksuccino.fancymenu.events.screen.RenderScreenEvent;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.rendering.AspectRatio;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.screen.ScreenRenderUtils;
import de.keksuccino.fancymenu.util.rendering.ui.screen.scrollnormalizer.ScrollScreenNormalizer;
import de.keksuccino.fancymenu.util.resource.PlayableResource;
import de.keksuccino.fancymenu.util.resource.RenderableResource;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class GameIntroOverlay
extends Overlay {
    private static final Logger LOGGER = LogManager.getLogger();
    protected Font font;
    @NotNull
    protected Screen fadeTo;
    protected PlayableResource intro;
    protected float opacity;
    protected long start;
    protected boolean fadeToInitialized;
    protected int width;
    protected int height;

    public GameIntroOverlay(@NotNull Screen fadeTo, @NotNull PlayableResource intro) {
        this.font = Minecraft.m_91087_().f_91062_;
        this.opacity = 1.0f;
        this.start = -1L;
        this.fadeToInitialized = false;
        this.fadeTo = Objects.requireNonNull(fadeTo);
        this.intro = Objects.requireNonNull(intro);
        this.intro.waitForReady(5000L);
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.width = Minecraft.m_91087_().m_91268_().m_85445_();
        this.height = Minecraft.m_91087_().m_91268_().m_85446_();
        if (this.start == -1L) {
            this.start = System.currentTimeMillis();
            this.intro.stop();
            this.intro.play();
        }
        if (this.endOfIntroReached() && !this.fadeToInitialized) {
            this.initFadeToScreen();
        }
        this.tickFadeOut();
        if (this.endOfIntroReached() && (!this.fadeOutIntro() || this.opacity < 0.1f)) {
            this.close();
            return;
        }
        if (this.endOfIntroReached()) {
            ScreenRenderUtils.executeAllPreRenderTasks(graphics, mouseX, mouseY, partial);
            EventHandler.INSTANCE.postEvent(new RenderScreenEvent.Pre(this.fadeTo, graphics, mouseX, mouseY, partial));
            this.fadeTo.m_88315_(graphics, mouseX, mouseY, partial);
            EventHandler.INSTANCE.postEvent(new RenderScreenEvent.Post(this.fadeTo, graphics, mouseX, mouseY, partial));
            ScreenRenderUtils.executeAllPostRenderTasks(graphics, mouseX, mouseY, partial);
        } else {
            graphics.m_280509_(0, 0, this.width, this.height, DrawableColor.BLACK.getColorInt());
        }
        RenderingUtils.resetShaderColor(graphics);
        this.renderIntro(graphics, mouseX, mouseY, partial);
        this.renderSkipText(graphics, mouseX, mouseY, partial);
    }

    protected void renderIntro(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        PlayableResource playableResource = this.intro;
        if (playableResource instanceof RenderableResource) {
            RenderableResource r = (RenderableResource)((Object)playableResource);
            AspectRatio ratio = r.getAspectRatio();
            int[] size = ratio.getAspectRatioSizeByMinimumSize(this.width, this.height);
            int aspectWidth = size[0];
            int aspectHeight = size[1];
            int x = this.width / 2 - aspectWidth / 2;
            int y = this.height / 2 - aspectHeight / 2;
            ResourceLocation location = r.getResourceLocation();
            if (location != null) {
                RenderSystem.enableBlend();
                graphics.m_280246_(1.0f, 1.0f, 1.0f, this.opacity);
                graphics.m_280163_(location, x, y, 0.0f, 0.0f, aspectWidth, aspectHeight, aspectWidth, aspectHeight);
            }
            RenderingUtils.resetShaderColor(graphics);
        }
    }

    protected void renderSkipText(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (FancyMenu.getOptions().gameIntroAllowSkip.getValue().booleanValue()) {
            float scale = 1.3f;
            String customSkipText = FancyMenu.getOptions().gameIntroCustomSkipText.getValue();
            if (!customSkipText.isEmpty() && LocalizationUtils.isLocalizationKey(customSkipText)) {
                customSkipText = I18n.m_118938_((String)customSkipText, (Object[])new Object[0]);
            }
            MutableComponent skipComp = customSkipText.isEmpty() ? Component.m_237115_((String)"fancymenu.game_intro.press_any_key") : Component.m_237113_((String)customSkipText);
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(scale, scale, scale);
            RenderSystem.enableBlend();
            RenderingUtils.resetShaderColor(graphics);
            int normalizedWidth = (int)((float)this.width / scale);
            int normalizedHeight = (int)((float)this.height / scale);
            int textX = normalizedWidth / 2 - this.font.m_92852_((FormattedText)skipComp) / 2;
            int textY = normalizedHeight - 40;
            graphics.m_280614_(this.font, (Component)skipComp, textX, textY, RenderingUtils.replaceAlphaInColor(DrawableColor.WHITE.getColorInt(), Math.max(0.1f, 0.6f * this.opacity)), false);
            graphics.m_280168_().m_85849_();
            RenderingUtils.resetShaderColor(graphics);
        }
    }

    protected boolean fadeOutIntro() {
        return FancyMenu.getOptions().gameIntroFadeOut.getValue();
    }

    protected boolean endOfIntroReached() {
        if (this.start == -1L) {
            return false;
        }
        long now = System.currentTimeMillis();
        return this.start + 2000L < now && !this.intro.isPlaying();
    }

    protected void tickFadeOut() {
        if (this.endOfIntroReached() && this.fadeOutIntro()) {
            this.opacity -= 0.02f;
        }
    }

    protected void initFadeToScreen() {
        ScreenCustomization.setIsNewMenu(true);
        ScreenCustomizationLayer layer = ScreenCustomizationLayerHandler.getLayerOfScreen(this.fadeTo);
        if (layer != null) {
            layer.resetLayer();
        }
        EventHandler.INSTANCE.postEvent(new InitOrResizeScreenStartingEvent(this.fadeTo, InitOrResizeScreenEvent.InitializationPhase.INIT));
        EventHandler.INSTANCE.postEvent(new InitOrResizeScreenEvent.Pre(this.fadeTo, InitOrResizeScreenEvent.InitializationPhase.INIT));
        this.fadeTo.m_6575_(Minecraft.m_91087_(), Minecraft.m_91087_().m_91268_().m_85445_(), Minecraft.m_91087_().m_91268_().m_85446_());
        ScrollScreenNormalizer.normalizeScrollableScreen(this.fadeTo);
        EventHandler.INSTANCE.postEvent(new InitOrResizeScreenEvent.Post(this.fadeTo, InitOrResizeScreenEvent.InitializationPhase.INIT));
        EventHandler.INSTANCE.postEvent(new InitOrResizeScreenCompletedEvent(this.fadeTo, InitOrResizeScreenEvent.InitializationPhase.INIT));
        this.fadeToInitialized = true;
    }

    protected void close() {
        if (!this.fadeToInitialized) {
            this.initFadeToScreen();
        }
        Minecraft.m_91087_().m_91150_(null);
    }

    public void keyPressed(int keycode, int scancode, int modifiers) {
        if (FancyMenu.getOptions().gameIntroAllowSkip.getValue().booleanValue()) {
            this.close();
        }
    }

    public void mouseClicked(int button) {
        if (FancyMenu.getOptions().gameIntroAllowSkip.getValue().booleanValue()) {
            this.close();
        }
    }
}

