/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.trees;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.Stack;
import me.pandamods.fallingtrees.api.TreeData;
import me.pandamods.fallingtrees.api.TreeType;
import me.pandamods.fallingtrees.config.ClientConfig;
import me.pandamods.fallingtrees.config.FallingTreesConfig;
import me.pandamods.fallingtrees.config.common.tree.GenericTreeConfig;
import me.pandamods.fallingtrees.entity.TreeEntity;
import me.pandamods.fallingtrees.exceptions.TreeTooBigException;
import me.pandamods.fallingtrees.registry.SoundRegistry;
import me.pandamods.pandalib.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class GenericTree
implements TreeType {
    @Override
    public boolean isTreeStem(BlockState blockState) {
        return this.getConfig().logFilter.isValid(blockState);
    }

    @Override
    public void onTreeTick(TreeEntity entity) {
        if (Services.GAME.isClient()) {
            ClientConfig clientConfig = FallingTreesConfig.getClientConfig();
            if (entity.f_19797_ == 1 && clientConfig.soundSettings.enabled) {
                entity.m_9236_().m_7785_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)SoundRegistry.TREE_FALL.get(), SoundSource.BLOCKS, clientConfig.soundSettings.startVolume, 1.0f, true);
            }
            if (entity.f_19797_ == (int)(clientConfig.animation.fallAnimLength * 20.0f) - 5 && clientConfig.soundSettings.enabled) {
                entity.m_9236_().m_7785_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)SoundRegistry.TREE_IMPACT.get(), SoundSource.BLOCKS, clientConfig.soundSettings.endVolume, 1.0f, true);
            }
        }
    }

    @Override
    public TreeData gatherTreeData(BlockPos blockPos, Level level, Player player) {
        if (this.getConfig().requireTool && !this.getConfig().allowedToolFilter.isValid(player.m_21205_())) {
            return null;
        }
        blockPos = blockPos.m_7949_();
        TreeData.Builder builder = TreeData.builder();
        if (!this.isLogBlock(level.m_8055_(blockPos))) {
            return null;
        }
        Set<BlockPos> logs = this.gatherLogs(level, blockPos);
        if (logs.isEmpty()) {
            return null;
        }
        HashSet<BlockPos> leaves = new HashSet<BlockPos>();
        for (BlockPos logPos2 : logs) {
            leaves.addAll(this.gatherLeavesAroundLog(level, logPos2));
        }
        if (leaves.isEmpty()) {
            return null;
        }
        Set<BlockPos> adjacent = this.gatherAdjacentBlocks(level, logs, leaves);
        HashSet<BlockPos> allBlocks = new HashSet<BlockPos>(logs);
        allBlocks.addAll(leaves);
        allBlocks.addAll(adjacent);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (BlockPos block : allBlocks) {
            BlockState blockState = level.m_8055_(block);
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            List items = Block.m_49874_((BlockState)blockState, (ServerLevel)serverLevel, (BlockPos)block, null, (Entity)player, (ItemStack)player.m_21205_());
            drops.addAll(items);
        }
        return builder.addBlocks(allBlocks).setToolDamage(logs.size()).setFoodExhaustionModifier(originalExhaustion -> originalExhaustion * (float)logs.size()).addDrops(drops).setMiningSpeedModifier(originalMiningSpeed -> {
            float speedMultiplication = FallingTreesConfig.getCommonConfig().dynamicMiningSpeed.speedMultiplication;
            float multiplyAmount = Math.min(FallingTreesConfig.getCommonConfig().dynamicMiningSpeed.maxSpeedMultiplication, (float)logs.size() - 1.0f);
            return originalMiningSpeed / (multiplyAmount * speedMultiplication + 1.0f);
        }).addAwardedStats(logs.stream().map(logPos -> {
            BlockState blockState = level.m_8055_(logPos);
            return Stats.f_12949_.m_12902_((Object)blockState.m_60734_());
        }).toList()).build();
    }

    private Set<BlockPos> gatherLogs(Level level, BlockPos startPos) {
        HashSet<BlockPos> logs = new HashSet<BlockPos>();
        LinkedList<BlockPos> toVisit = new LinkedList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        toVisit.add(startPos);
        while (!toVisit.isEmpty()) {
            BlockPos current = (BlockPos)toVisit.poll();
            if (visited.contains(current)) continue;
            visited.add(current);
            BlockState currentState = level.m_8055_(current);
            if (!this.isLogBlock(currentState)) continue;
            logs.add(current);
            if (logs.size() > this.getConfig().algorithm.maxLogAmount) {
                throw new TreeTooBigException(current, level);
            }
            for (BlockPos offset : BlockPos.m_121976_((int)-1, (int)0, (int)-1, (int)1, (int)1, (int)1)) {
                BlockPos neighbor = current.m_121955_((Vec3i)offset);
                if (visited.contains(neighbor)) continue;
                toVisit.add(neighbor);
            }
        }
        return logs;
    }

    private Set<BlockPos> gatherLeavesAroundLog(Level level, BlockPos logPos) {
        HashSet<BlockPos> leaves = new HashSet<BlockPos>();
        LinkedList<BlockSearchNode> toVisit = new LinkedList<BlockSearchNode>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        for (Direction direction : Direction.values()) {
            BlockPos neighbor = logPos.m_121945_(direction);
            toVisit.add(new BlockSearchNode(neighbor, 1));
        }
        while (!toVisit.isEmpty()) {
            BlockSearchNode node = (BlockSearchNode)toVisit.poll();
            BlockPos current = node.position;
            BlockState currentState = level.m_8055_(current);
            OptionalInt optionalDistanceAt = LeavesBlock.m_277200_((BlockState)currentState);
            if (node.distance != optionalDistanceAt.orElse(0) || visited.contains(current) || node.distance > this.getConfig().algorithm.maxLeavesRadius) continue;
            visited.add(current);
            if (!this.isLeafBlock(currentState)) continue;
            leaves.add(current);
            for (Direction direction : Direction.values()) {
                BlockPos nextPos = current.m_121945_(direction);
                if (visited.contains(nextPos)) continue;
                toVisit.add(new BlockSearchNode(nextPos, node.distance + 1));
            }
        }
        return leaves;
    }

    private Set<BlockPos> gatherAdjacentBlocks(Level level, Set<BlockPos> logs, Set<BlockPos> leaves) {
        HashSet<BlockPos> adjacentBlocks = new HashSet<BlockPos>();
        HashSet<BlockPos> allTreeBlocks = new HashSet<BlockPos>(logs);
        allTreeBlocks.addAll(leaves);
        for (BlockPos blockPos : allTreeBlocks) {
            for (Direction dir : Direction.values()) {
                BlockPos neighbor = blockPos.m_121945_(dir);
                BlockState neighborState = level.m_8055_(neighbor);
                if (neighborState.m_60713_(Blocks.f_50191_)) {
                    adjacentBlocks.addAll(this.gatherVines(level, neighbor));
                    continue;
                }
                if (neighborState.m_60713_(Blocks.f_50717_)) {
                    adjacentBlocks.add(neighbor);
                    continue;
                }
                if (!neighborState.m_60713_(Blocks.f_50262_)) continue;
                adjacentBlocks.add(neighbor);
            }
        }
        return adjacentBlocks;
    }

    private Set<BlockPos> gatherVines(Level level, BlockPos startPos) {
        HashSet<BlockPos> vines = new HashSet<BlockPos>();
        Stack<BlockPos> toVisit = new Stack<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        toVisit.push(startPos);
        while (!toVisit.isEmpty()) {
            BlockPos current = (BlockPos)toVisit.pop();
            if (visited.contains(current)) continue;
            visited.add(current);
            BlockState currentState = level.m_8055_(current);
            if (!currentState.m_60713_(Blocks.f_50191_)) continue;
            vines.add(current);
            BlockPos neighbor = current.m_7495_();
            if (visited.contains(neighbor)) continue;
            toVisit.push(neighbor);
        }
        return vines;
    }

    private boolean isLogBlock(BlockState blockState) {
        return this.getConfig().logFilter.isValid(blockState);
    }

    private boolean isLeafBlock(BlockState blockState) {
        if (this.getConfig().algorithm.shouldIgnorePersistentLeaves && blockState.m_61138_((Property)BlockStateProperties.f_61447_) && ((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61447_)).booleanValue()) {
            return false;
        }
        return this.getConfig().leavesFilter.isValid(blockState);
    }

    public GenericTreeConfig getConfig() {
        return FallingTreesConfig.getCommonConfig().trees.genericTree;
    }

    private record BlockSearchNode(BlockPos position, int distance) {
    }
}

