/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.config.common.tree;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class TreeConfig {
    public boolean enabled = true;
    public boolean requireTool = false;
    public Filter allowedToolFilter = new Filter(new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>());

    public static class Filter {
        public List<String> whitelistedTags;
        public List<String> whitelist;
        public List<String> blacklist;

        public Filter(List<String> whitelistedBlockTags, List<String> whitelistedBlocks, List<String> blacklistedBlocks) {
            this.whitelistedTags = whitelistedBlockTags;
            this.whitelist = whitelistedBlocks;
            this.blacklist = blacklistedBlocks;
        }

        public boolean isValid(BlockState blockState) {
            Block block = blockState.m_60734_();
            ResourceLocation resourceLocation = BuiltInRegistries.f_256975_.m_7981_((Object)block);
            if (this.blacklist.contains(resourceLocation.toString())) {
                return false;
            }
            return blockState.m_204343_().anyMatch(blockTagKey -> this.whitelistedTags.contains(blockTagKey.f_203868_().toString())) || this.whitelist.contains(resourceLocation.toString());
        }

        public boolean isValid(ItemStack itemStack) {
            Item item = itemStack.m_41720_();
            ResourceLocation resourceLocation = BuiltInRegistries.f_257033_.m_7981_((Object)item);
            if (this.blacklist.contains(resourceLocation.toString())) {
                return false;
            }
            return itemStack.m_204131_().anyMatch(blockTagKey -> this.whitelistedTags.contains(blockTagKey.f_203868_().toString())) || this.whitelist.contains(resourceLocation.toString());
        }
    }
}

