/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.fallingtrees.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import me.pandamods.fallingtrees.api.TreeType;
import me.pandamods.fallingtrees.config.ClientConfig;
import me.pandamods.fallingtrees.config.FallingTreesConfig;
import me.pandamods.fallingtrees.entity.TreeEntity;
import me.pandamods.fallingtrees.utils.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class TreeRenderer
extends EntityRenderer<TreeEntity> {
    public TreeRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public ClientConfig getConfig() {
        return FallingTreesConfig.getClientConfig((Player)Minecraft.m_91087_().f_91074_);
    }

    public void render(TreeEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        TreeType tree = entity.treeType;
        if (tree == null) {
            return;
        }
        poseStack.m_85836_();
        Map<BlockPos, BlockState> blocks = entity.getBlocks();
        float fallAnimLength = this.getConfig().animation.fallAnimLength;
        float bounceHeight = this.getConfig().animation.bounceAngleHeight;
        float bounceAnimLength = this.getConfig().animation.bounceAnimLength;
        float time = (float)((double)entity.getLifetime(partialTick) * 1.5707963267948966 / (double)fallAnimLength);
        float fallAnim = this.bumpCos(time) * 90.0f;
        float bounceAnim = this.bumpSin((float)(((double)time - 1.5707963267948966) / (double)(bounceAnimLength / (fallAnimLength * 2.0f)))) * bounceHeight;
        float animation = fallAnim + bounceAnim - 90.0f;
        Direction direction = entity.m_6350_().m_122424_();
        float distance = this.getDistance(tree, blocks, direction.m_122424_());
        Vector3f pivot = new Vector3f(0.0f, 0.0f, 0.5f + distance);
        pivot.rotateY(Math.toRadians((float)(-direction.m_122435_())));
        poseStack.m_252880_(-pivot.x, 0.0f, -pivot.z);
        Vector3f vector = new Vector3f(Math.toRadians((float)animation), 0.0f, 0.0f);
        vector.rotateY(Math.toRadians((float)(-direction.m_122435_())));
        Quaternionf quaternion = new Quaternionf().identity().rotateX(vector.x).rotateZ(vector.z);
        poseStack.m_252781_(quaternion);
        Level level = entity.m_9236_();
        poseStack.m_252880_(pivot.x, 0.0f, pivot.z);
        poseStack.m_85837_(-0.5, 0.0, -0.5);
        blocks.forEach((blockPos, blockState) -> {
            poseStack.m_85836_();
            poseStack.m_252880_((float)blockPos.m_123341_(), (float)blockPos.m_123342_(), (float)blockPos.m_123343_());
            blockPos = blockPos.m_121955_((Vec3i)entity.getOriginPos());
            RenderUtils.renderSingleBlock(poseStack, blockState, blockPos, (BlockAndTintGetter)level, bufferSource, packedLight);
            poseStack.m_85849_();
        });
        poseStack.m_85849_();
    }

    private float getDistance(TreeType tree, Map<BlockPos, BlockState> blocks, Direction direction) {
        float distance = 0.0f;
        BlockPos currentPos = new BlockPos(0, 0, 0);
        BlockPos next = currentPos.m_121945_(direction);
        while (blocks.containsKey(next) && tree.isTreeStem(blocks.get(next))) {
            currentPos = next;
            next = currentPos.m_121945_(direction);
            distance += 1.0f;
        }
        BlockState blockState = blocks.get(currentPos);
        if (blockState.m_271730_()) {
            return distance - 0.5f;
        }
        VoxelShape shape = blockState.m_60812_((BlockGetter)Minecraft.m_91087_().f_91073_, currentPos);
        if (shape.m_83281_()) {
            shape = blockState.m_60808_((BlockGetter)Minecraft.m_91087_().f_91073_, currentPos);
        }
        if (!shape.m_83281_()) {
            AABB bounds = shape.m_83215_();
            switch (direction) {
                case WEST: {
                    distance -= (float)bounds.f_82288_;
                    break;
                }
                case EAST: {
                    distance -= (float)(1.0 - bounds.f_82291_);
                    break;
                }
                case SOUTH: {
                    distance -= (float)bounds.f_82290_;
                    break;
                }
                case NORTH: {
                    distance -= (float)(1.0 - bounds.f_82293_);
                }
            }
        } else {
            distance -= 1.0f;
        }
        return distance;
    }

    private float bumpCos(float time) {
        return (float)Math.max((double)0.0, (double)Math.cos((double)Math.clamp((double)(-java.lang.Math.PI), (double)java.lang.Math.PI, (double)time)));
    }

    private float bumpSin(float time) {
        return (float)Math.max((double)0.0, (double)Math.sin((double)Math.clamp((double)(-java.lang.Math.PI), (double)java.lang.Math.PI, (double)time)));
    }

    public ResourceLocation getTextureLocation(TreeEntity entity) {
        return null;
    }
}

