/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.particle;

import de.cheaterpaul.fallingleaves.init.ClientMod;
import de.cheaterpaul.fallingleaves.init.FallingLeavesConfig;
import de.cheaterpaul.fallingleaves.util.Wind;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.FluidTags;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class FallingLeafParticle
extends TextureSheetParticle {
    protected static final float TAU = (float)Math.PI * 2;
    protected static final int FADE_DURATION = 16;
    protected static final double WATER_FRICTION = 0.05;
    protected final float windCoefficient;
    protected final float maxRotateSpeed;
    protected final int maxRotateTime;
    protected int rotateTime = 0;

    protected FallingLeafParticle(ClientLevel clientWorld, double x, double y, double z, double r, double g, double b, SpriteSet provider) {
        super(clientWorld, x, y, z, 0.0, 0.0, 0.0);
        this.m_108335_(provider);
        this.f_107226_ = 0.08f + this.f_107223_.m_188501_() * 0.04f;
        this.windCoefficient = 0.6f + this.f_107223_.m_188501_() * 0.4f;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.f_107219_ = true;
        this.f_107225_ = (Integer)FallingLeavesConfig.CONFIG.leafLifespan.get();
        this.f_107227_ = (float)r;
        this.f_107228_ = (float)g;
        this.f_107229_ = (float)b;
        this.maxRotateTime = (3 + this.f_107223_.m_188503_(5)) * 20;
        this.maxRotateSpeed = (float)(this.f_107223_.m_188499_() ? -1 : 1) * (0.1f + 2.4f * this.f_107223_.m_188501_()) * ((float)Math.PI * 2) / 20.0f;
        this.f_107231_ = this.f_107204_ = this.f_107223_.m_188501_() * ((float)Math.PI * 2);
        this.f_107663_ = (float)((Integer)FallingLeavesConfig.CONFIG.leafSize.get()).intValue() / 50.0f;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.f_107204_ = this.f_107231_;
        ++this.f_107224_;
        if (this.f_107224_ >= this.f_107225_ + 1 - 16) {
            this.f_107230_ -= 0.0625f;
        }
        if (this.f_107224_ >= this.f_107225_) {
            this.m_107274_();
            return;
        }
        if (this.f_107208_.m_6425_(new BlockPos((int)this.f_107212_, (int)this.f_107213_, (int)this.f_107214_)).m_205070_(FluidTags.f_13131_)) {
            this.f_107216_ = 0.0;
            this.rotateTime = 0;
            this.f_107215_ *= 0.95;
            this.f_107217_ *= 0.95;
        } else {
            this.f_107216_ -= 0.04 * (double)this.f_107226_;
            if (!this.f_107218_) {
                this.rotateTime = Math.min(this.rotateTime + 1, this.maxRotateTime);
                this.f_107231_ += (float)this.rotateTime / (float)this.maxRotateTime * this.maxRotateSpeed;
            } else {
                this.rotateTime = 0;
            }
            this.f_107215_ += ((double)Wind.windX - this.f_107215_) * (double)this.windCoefficient / 60.0;
            this.f_107217_ += ((double)Wind.windZ - this.f_107217_) * (double)this.windCoefficient / 60.0;
        }
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LeavesParticleFactory
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(@Nullable SimpleParticleType parameters, @NotNull ClientLevel world, double x, double y, double z, double r, double g, double b) {
            return new FallingLeafParticle(world, x, y, z, r, g, b, ClientMod.getSpriteForLeafType(ClientMod.DEFAULT));
        }

        public Particle createParticle(@Nullable SimpleParticleType parameters, @NotNull ClientLevel world, double x, double y, double z, double r, double g, double b, SpriteSet spriteSet) {
            return new FallingLeafParticle(world, x, y, z, r, g, b, spriteSet);
        }
    }
}

