/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.extractinator.common.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import tech.alexnijjar.extractinator.common.block.ExtractinatorContainer;
import tech.alexnijjar.extractinator.common.config.ExtractinatorConfig;
import tech.alexnijjar.extractinator.common.recipe.ExtractinatorRecipe;
import tech.alexnijjar.extractinator.common.registry.ModBlockEntityTypes;
import tech.alexnijjar.extractinator.common.registry.ModRecipeTypes;
import tech.alexnijjar.extractinator.common.util.ModUtils;

public class ExtractinatorBlockEntity
extends BlockEntity
implements ExtractinatorContainer {
    private final NonNullList<ItemStack> inventory;
    protected int remainingUsages;
    @Nullable
    private ExtractinatorRecipe recipe;
    private ItemStack prevInput = ItemStack.f_41583_;

    public ExtractinatorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntityTypes.EXTRACTINATOR.get(), blockPos, blockState);
        this.inventory = NonNullList.m_122780_((int)33, (Object)ItemStack.f_41583_);
    }

    public void serverTick() {
        if (this.f_58857_.m_46467_() % (long)ExtractinatorConfig.extractTicks == 0L) {
            this.extractinate();
        }
    }

    protected void extractinate() {
        if (this.f_58857_ != null) {
            this.dispenseItems();
            this.placeBlockAbove();
            this.extractBlockAbove();
            this.extractItems();
            this.m_6596_();
        }
    }

    protected void placeBlockAbove() {
        BlockState above = this.f_58857_.m_8055_(this.m_58899_().m_7494_());
        ItemStack input = (ItemStack)this.inventory.get(0);
        Block toPlace = Block.m_49814_((Item)input.m_41720_());
        if (toPlace == Blocks.f_50016_) {
            return;
        }
        if (above.m_60795_() || Blocks.f_49990_.equals(above.m_60734_())) {
            this.f_58857_.m_7731_(this.m_58899_().m_7494_(), toPlace.m_49966_(), 4);
        } else {
            List<ItemStack> outputs;
            if (!ExtractinatorConfig.silent) {
                this.f_58857_.m_5594_(null, this.m_58899_(), toPlace.m_49962_(above).m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (!(outputs = ModUtils.extractItem(this.recipe, this.f_58857_)).isEmpty()) {
                outputs.forEach(this::addItem);
            }
        }
        this.m_8020_(0).m_41774_(1);
    }

    protected void extractBlockAbove() {
        BlockState above = this.f_58857_.m_8055_(this.m_58899_().m_7494_());
        if (above.m_60795_()) {
            return;
        }
        this.extractStack(above.m_60734_().m_5456_().m_7968_());
    }

    protected void extractItems() {
        ItemStack stack = this.m_8020_(0);
        if (stack.m_41720_() instanceof BlockItem) {
            return;
        }
        if (this.extractStack(stack)) {
            stack.m_41774_(1);
        }
    }

    protected boolean extractStack(ItemStack stack) {
        if (!this.isValidInput(stack)) {
            return false;
        }
        if (ExtractinatorConfig.silent) {
            this.f_58857_.m_7471_(this.m_58899_().m_7494_(), false);
        } else {
            this.f_58857_.m_46961_(this.m_58899_().m_7494_(), false);
        }
        List<ItemStack> outputs = ModUtils.extractItem(this.recipe, this.f_58857_);
        this.damage();
        if (!outputs.isEmpty()) {
            outputs.forEach(this::addItem);
        }
        return true;
    }

    protected void dispenseItems() {
        for (int i = 1; i < this.getInventory().size(); ++i) {
            ItemStack stack = this.m_8020_(i);
            if (stack.m_41619_() || !this.f_58857_.m_8055_(this.m_58899_().m_7494_()).m_60795_()) continue;
            BlockPos pos = this.m_58899_();
            ItemEntity itemEntity = new ItemEntity(this.f_58857_, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 2.0f), (double)((float)pos.m_123343_() + 0.5f), stack.m_41777_());
            itemEntity.m_20256_(itemEntity.m_20184_().m_82490_(1.5));
            stack.m_41764_(0);
            this.f_58857_.m_7967_((Entity)itemEntity);
            break;
        }
    }

    public void damage() {
        if (this.f_58857_ != null && ExtractinatorConfig.extractinatorDurability > 0) {
            --this.remainingUsages;
            if (this.remainingUsages == 0) {
                this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11665_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.f_58857_.m_46961_(this.m_58899_(), false);
            }
        }
    }

    protected void m_183515_(CompoundTag tag) {
        ContainerHelper.m_18973_((CompoundTag)tag, this.inventory);
        tag.m_128405_("RemainingUsages", this.remainingUsages);
    }

    public void m_142466_(CompoundTag tag) {
        ContainerHelper.m_18980_((CompoundTag)tag, this.inventory);
        this.remainingUsages = tag.m_128451_("RemainingUsages");
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isValidInput(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (!ItemStack.m_41656_((ItemStack)this.prevInput, (ItemStack)stack)) {
            this.recipe = this.f_58857_.m_7465_().m_44013_((RecipeType)ModRecipeTypes.EXTRACTINATOR_RECIPE.get()).stream().filter(r -> r.matches(stack)).findFirst().orElse(null);
        }
        this.prevInput = stack;
        return ModUtils.isValidInput(this.recipe, stack);
    }
}

