/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg;

import java.util.List;
import java.util.Set;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.liukrast.eg.EGConstants;
import net.liukrast.eg.ExtraGaugesConfig;
import net.liukrast.eg.ExtraGaugesPonderPlugin;
import net.liukrast.eg.api.EGRegistries;
import net.liukrast.eg.datagen.ExtraGaugesBlockModelProvider;
import net.liukrast.eg.datagen.ExtraGaugesBlockStateProvider;
import net.liukrast.eg.datagen.ExtraGaugesItemModelProvider;
import net.liukrast.eg.datagen.ExtraGaugesLootTableProvider;
import net.liukrast.eg.datagen.ExtraGaugesRecipeProvider;
import net.liukrast.eg.registry.EGBlockEntityTypes;
import net.liukrast.eg.registry.EGBlocks;
import net.liukrast.eg.registry.EGCreativeModeTabs;
import net.liukrast.eg.registry.EGDisplayTargets;
import net.liukrast.eg.registry.EGExtraPanelConnections;
import net.liukrast.eg.registry.EGItems;
import net.liukrast.eg.registry.EGPanelConnections;
import net.liukrast.eg.registry.EGPanels;
import net.liukrast.eg.registry.EGPartialModels;
import net.liukrast.eg.registry.RegisterPackets;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;

@Mod(value="extra_gauges")
public class EG {
    public EG(FMLJavaModLoadingContext ctx) {
        IEventBus modEventBus = ctx.getModEventBus();
        EGItems.register(modEventBus);
        EGPanels.register(modEventBus);
        EGCreativeModeTabs.register(modEventBus);
        EGPanelConnections.register(modEventBus);
        EGBlocks.register(modEventBus);
        EGBlockEntityTypes.register(modEventBus);
        EGDisplayTargets.register(modEventBus);
        modEventBus.register((Object)this);
        ctx.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ExtraGaugesConfig.SPEC);
        RegisterPackets.registerPackets();
        MinecraftForge.EVENT_BUS.addListener(this::loadLevel);
        IEventBus bus = ctx.getModEventBus();
        EGPartialModels.init();
        bus.register((Object)this);
        bus.addListener(EGBlockEntityTypes::registerRenderers);
        ctx.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ExtraGaugesConfig.CLIENT_SPEC);
    }

    public void loadLevel(LevelEvent.Load event) {
        EGExtraPanelConnections.register();
        EGPanelConnections.initDefaults();
    }

    @SubscribeEvent
    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        generator.addProvider(event.includeClient(), (DataProvider)new ExtraGaugesItemModelProvider(packOutput, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new ExtraGaugesBlockModelProvider(packOutput, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new ExtraGaugesBlockStateProvider(packOutput, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new ExtraGaugesRecipeProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(ExtraGaugesLootTableProvider::new, LootContextParamSets.f_81421_))));
    }

    @SubscribeEvent
    public void newRegistry(NewRegistryEvent event) {
        EGRegistries.PANEL_REGISTRY = event.create(RegistryBuilder.of((ResourceLocation)EGConstants.id("panels", new Object[0])));
        EGRegistries.PANEL_CONNECTION_REGISTRY = event.create(RegistryBuilder.of((ResourceLocation)EGConstants.id("panel_connections", new Object[0])));
    }

    @SubscribeEvent
    public void fMLClientSetup(FMLClientSetupEvent event) {
        PonderIndex.addPlugin((PonderPlugin)new ExtraGaugesPonderPlugin());
    }
}

