/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.util;

import io.github.mortuusars.exposure.camera.Camera;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.util.ItemAndStack;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class CameraInHand<T extends CameraItem>
extends Camera<T> {
    private final InteractionHand hand;
    private final ItemAndStack<T> cameraItemAndStack;

    @Nullable
    public static <T extends CameraItem> Camera<T> ofPlayer(Player player, Class<T> clazz) {
        for (InteractionHand hand : InteractionHand.values()) {
            CameraItem cameraItem;
            ItemStack itemInHand = player.m_21120_(hand);
            Item item = itemInHand.m_41720_();
            if (!(item instanceof CameraItem) || !(cameraItem = (CameraItem)item).isActive(itemInHand) || !itemInHand.m_41720_().getClass().equals(clazz)) continue;
            return new CameraInHand(hand, new ItemAndStack(itemInHand));
        }
        return null;
    }

    public CameraInHand(InteractionHand hand, @Nullable ItemAndStack<T> cameraItemAndStack) {
        this.hand = hand;
        this.cameraItemAndStack = cameraItemAndStack;
    }

    @Override
    public void activate(Player player) {
        ((CameraItem)((Object)this.get().getItem())).activate(player, this.get().getStack());
    }

    @Override
    public void deactivate(Player player) {
        ((CameraItem)((Object)this.get().getItem())).deactivate(player, this.get().getStack());
    }

    @Override
    public ItemAndStack<T> get() {
        return this.cameraItemAndStack;
    }

    public InteractionHand getHand() {
        return this.hand;
    }
}

