/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.render;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.render.image.IImage;
import io.github.mortuusars.exposure.render.image.RenderedImageProvider;
import io.github.mortuusars.exposure.render.modifiers.IPixelModifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class ExposureRenderer
implements AutoCloseable {
    private final Map<String, ExposureInstance> cache = new HashMap<String, ExposureInstance>();

    public int getSize() {
        return 256;
    }

    public void render(@NotNull RenderedImageProvider imageProvider, IPixelModifier modifier, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int r, int g, int b, int a) {
        this.render(imageProvider, modifier, poseStack, bufferSource, 0.0f, 0.0f, this.getSize(), this.getSize(), packedLight, r, g, b, a);
    }

    public void render(@NotNull RenderedImageProvider imageProvider, IPixelModifier modifier, PoseStack poseStack, MultiBufferSource bufferSource, float x, float y, float width, float height, int packedLight, int r, int g, int b, int a) {
        this.render(imageProvider, modifier, poseStack, bufferSource, x, y, x + width, y + height, 0.0f, 0.0f, 1.0f, 1.0f, packedLight, r, g, b, a);
    }

    public void render(@NotNull RenderedImageProvider imageProvider, IPixelModifier modifier, PoseStack poseStack, MultiBufferSource bufferSource, float minX, float minY, float maxX, float maxY, float minU, float minV, float maxU, float maxV, int packedLight, int r, int g, int b, int a) {
        this.getOrCreateExposureInstance(imageProvider, modifier).draw(poseStack, bufferSource, minX, minY, maxX, maxY, minU, minV, maxU, maxV, packedLight, r, g, b, a);
    }

    private ExposureInstance getOrCreateExposureInstance(RenderedImageProvider imageProvider, IPixelModifier modifier) {
        String instanceId = imageProvider.getInstanceId() + modifier.getIdSuffix();
        return this.cache.compute(instanceId, (expId, expData) -> {
            if (expData == null) {
                return new ExposureInstance((String)expId, imageProvider.get(), modifier);
            }
            expData.replaceData(imageProvider.get());
            return expData;
        });
    }

    public void clearData() {
        for (ExposureInstance instance : this.cache.values()) {
            instance.close();
        }
        this.cache.clear();
    }

    public void clearDataSingle(@NotNull String exposureId, boolean allVariants) {
        Iterator<Map.Entry<String, ExposureInstance>> it = this.cache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, ExposureInstance> entry = it.next();
            if (!(allVariants ? entry.getKey().startsWith(exposureId) : entry.getKey().equals(exposureId))) continue;
            entry.getValue().close();
            it.remove();
            if (allVariants) continue;
            break;
        }
    }

    @Override
    public void close() {
        this.clearData();
    }

    static class ExposureInstance
    implements AutoCloseable {
        private static final Function<ResourceLocation, RenderType> TEXT_MIPMAP = Util.m_143827_(texture -> RenderType.m_173215_((String)"exposure_mipmap", (VertexFormat)DefaultVertexFormat.f_85820_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)786432, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderType.f_173086_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, true)).m_110685_(RenderType.f_110139_).m_110671_(RenderType.f_110152_).m_110691_(false)));
        protected final ResourceLocation textureLocation;
        protected final RenderType renderType;
        private IImage exposure;
        private DynamicTexture texture;
        private final IPixelModifier pixelModifier;
        private boolean requiresUpload = true;

        ExposureInstance(String id, IImage exposure, IPixelModifier modifier) {
            this.exposure = exposure;
            this.texture = new DynamicTexture(exposure.getWidth(), exposure.getHeight(), true);
            this.pixelModifier = modifier;
            String textureId = ExposureInstance.createTextureId(id);
            this.textureLocation = Minecraft.m_91087_().m_91097_().m_118490_(textureId, this.texture);
            int mipmapLevel = (Integer)Minecraft.m_91087_().f_91066_.m_232119_().m_231551_();
            this.renderType = mipmapLevel > 0 ? TEXT_MIPMAP.apply(this.textureLocation) : RenderType.m_110497_((ResourceLocation)this.textureLocation);
        }

        private static String createTextureId(String exposureId) {
            Object id = "exposure/" + exposureId.toLowerCase();
            id = ((String)id).replace(':', '_');
            Pattern pattern = Pattern.compile("[^a-z0-9_.-]");
            Matcher matcher = pattern.matcher((CharSequence)id);
            StringBuilder sb = new StringBuilder();
            while (matcher.find()) {
                matcher.appendReplacement(sb, String.valueOf(matcher.group().hashCode()));
            }
            matcher.appendTail(sb);
            return sb.toString();
        }

        private void replaceData(IImage exposure) {
            boolean hasChanged = !this.exposure.getImageId().equals(exposure.getImageId());
            this.exposure = exposure;
            if (hasChanged) {
                this.texture = new DynamicTexture(exposure.getWidth(), exposure.getHeight(), true);
            }
            this.requiresUpload |= hasChanged;
        }

        public void forceUpload() {
            this.requiresUpload = true;
        }

        private void updateTexture() {
            if (this.texture.m_117991_() == null) {
                return;
            }
            int width = this.exposure.getWidth();
            int height = this.exposure.getHeight();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int ABGR = this.exposure.getPixelABGR(x, y);
                    ABGR = this.pixelModifier.modifyPixel(ABGR);
                    this.texture.m_117991_().m_84988_(x, y, ABGR);
                }
            }
            int mipmapLevel = (Integer)Minecraft.m_91087_().f_91066_.m_232119_().m_231551_();
            if (mipmapLevel > 0 && width > 2 && height > 2) {
                this.applyMipMap(mipmapLevel, width, height);
            }
            this.texture.m_117985_();
        }

        private void applyMipMap(int mipmapLevel, int width, int height) {
            if (this.texture.m_117991_() == null) {
                return;
            }
            try {
                this.texture.m_117960_(false, true);
                TextureUtil.prepareImage((int)this.texture.m_117963_(), (int)mipmapLevel, (int)width, (int)height);
                SpriteContents spriteContents = new SpriteContents(this.textureLocation, new FrameSize(width, height), this.texture.m_117991_(), AnimationMetadataSection.f_119012_);
                spriteContents.m_246368_(mipmapLevel);
                spriteContents.m_246850_(0, 0);
            }
            catch (Exception e) {
                Exposure.LOGGER.error("Failed to generate mipmaps: {}", (Object)e.getMessage());
            }
        }

        void draw(PoseStack poseStack, MultiBufferSource bufferSource, float minX, float minY, float maxX, float maxY, float minU, float minV, float maxU, float maxV, int packedLight, int r, int g, int b, int a) {
            if (this.requiresUpload) {
                this.updateTexture();
                this.requiresUpload = false;
            }
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            VertexConsumer vertexconsumer = bufferSource.m_6299_(this.renderType);
            vertexconsumer.m_252986_(matrix4f, minX, maxY, 0.0f).m_6122_(r, g, b, a).m_7421_(minU, maxV).m_85969_(packedLight).m_5752_();
            vertexconsumer.m_252986_(matrix4f, maxX, maxY, 0.0f).m_6122_(r, g, b, a).m_7421_(maxU, maxV).m_85969_(packedLight).m_5752_();
            vertexconsumer.m_252986_(matrix4f, maxX, minY, 0.0f).m_6122_(r, g, b, a).m_7421_(maxU, minV).m_85969_(packedLight).m_5752_();
            vertexconsumer.m_252986_(matrix4f, minX, minY, 0.0f).m_6122_(r, g, b, a).m_7421_(minU, minV).m_85969_(packedLight).m_5752_();
        }

        @Override
        public void close() {
            this.texture.close();
        }
    }
}

