/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera.capture;

import com.google.common.io.Files;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.util.Either;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.capture.Capture;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileCapture
extends Capture {
    protected final String filepath;
    protected final Consumer<Error> onError;

    public FileCapture(String filepath) {
        this(filepath, err -> {});
    }

    public FileCapture(String filepath, Consumer<Error> onError) {
        this.filepath = filepath;
        this.onError = onError;
    }

    public String getFilepath() {
        return this.filepath;
    }

    @Override
    protected void addSavedDataProperties(CompoundTag tag) {
        super.addSavedDataProperties(tag);
        tag.m_128379_("FromFile", true);
    }

    @Override
    @Nullable
    public NativeImage captureImage() {
        return this.captureImage(this.getFilepath());
    }

    @Nullable
    public NativeImage captureImage(String filepath) {
        NativeImage nativeImage;
        Either<File, Error> fileOrError = FileCapture.findFileWithExtension(filepath);
        if (fileOrError.right().isPresent()) {
            this.onError.accept((Error)((Object)fileOrError.right().get()));
            return null;
        }
        File file = (File)fileOrError.left().orElseThrow();
        Optional<Error> error = FileCapture.validateFilepath(file.getPath());
        if (error.isPresent()) {
            this.onError.accept(error.get());
            return null;
        }
        FileInputStream inputStream = new FileInputStream(file);
        try {
            nativeImage = NativeImage.m_85048_((NativeImage.Format)NativeImage.Format.RGBA, (InputStream)inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Exposure.LOGGER.error("Loading image failed: {}", (Object)e.toString());
                this.onError.accept(Error.CANNOT_READ);
                return null;
            }
        }
        inputStream.close();
        return nativeImage;
    }

    public static Optional<Error> validateFilepath(@NotNull String filepath) {
        if (StringUtil.m_14408_((String)filepath)) {
            return Optional.of(Error.PATH_EMPTY);
        }
        File file = new File(filepath);
        if (file.isDirectory()) {
            return Optional.of(Error.PATH_IS_DIRECTORY);
        }
        String extension = Files.getFileExtension((String)filepath);
        if (StringUtil.m_14408_((String)extension)) {
            return Optional.of(Error.NO_EXTENSION);
        }
        if (!file.exists()) {
            return Optional.of(Error.FILE_DOES_NOT_EXIST);
        }
        return Optional.empty();
    }

    public static Either<File, Error> findFileWithExtension(String filepath) {
        File file = new File(filepath);
        String extension = Files.getFileExtension((String)filepath);
        if (!StringUtil.m_14408_((String)extension)) {
            return Either.left((Object)file);
        }
        @Nullable File parentFile = file.getParentFile();
        if (parentFile == null) {
            return Either.right((Object)((Object)Error.PATH_INVALID));
        }
        File[] files = parentFile.listFiles();
        if (files == null) {
            return Either.right((Object)((Object)Error.CANNOT_READ));
        }
        String name = file.getName();
        for (File fileInDirectory : files) {
            String fileName;
            if (fileInDirectory.isDirectory() || !(fileName = Files.getNameWithoutExtension((String)fileInDirectory.getName())).equals(name)) continue;
            return Either.left((Object)fileInDirectory);
        }
        return Either.right((Object)((Object)Error.FILE_DOES_NOT_EXIST));
    }

    public static enum Error {
        PATH_EMPTY("path_empty"),
        PATH_INVALID("path_invalid"),
        NO_EXTENSION("no_extension"),
        PATH_IS_DIRECTORY("path_is_directory"),
        FILE_DOES_NOT_EXIST("file_does_not_exist"),
        CANNOT_READ("cannot_read"),
        NOT_SUPPORTED("not_supported");

        private final String key;

        private Error(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public MutableComponent getCasualTranslation() {
            return Component.m_237115_((String)("exposure.file_capture.error.casual." + this.getKey()));
        }

        public MutableComponent getTechnicalTranslation() {
            return Component.m_237115_((String)("exposure.file_capture.error.technical." + this.getKey()));
        }
    }
}

