/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.api.record;

import gg.moonflower.etched.api.record.AlbumCover;
import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.api.sound.download.SoundSourceManager;
import java.net.Proxy;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public abstract class PlayableRecordItem
extends Item
implements PlayableRecord {
    private static final Component ALBUM = Component.m_237115_((String)"item.etched.etched_music_disc.album").m_130940_(ChatFormatting.DARK_GRAY);

    public PlayableRecordItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos;
        Level level = context.m_43725_();
        BlockState state = level.m_8055_(pos = context.m_8083_());
        if (!state.m_60713_(Blocks.f_50131_) || ((Boolean)state.m_61143_((Property)JukeboxBlock.f_54254_)).booleanValue()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.m_43722_();
        if (this.getMusic(stack).isEmpty()) {
            return InteractionResult.PASS;
        }
        if (!level.m_5776_()) {
            Player player = context.m_43723_();
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof JukeboxBlockEntity) {
                JukeboxBlockEntity jukeboxblockentity = (JukeboxBlockEntity)be;
                jukeboxblockentity.m_272287_(stack.m_41777_());
                level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)state));
            }
            stack.m_41774_(1);
            if (player != null) {
                player.m_36220_(Stats.f_12965_);
            }
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        this.getAlbum(stack).ifPresent(track -> {
            boolean album = this.getTrackCount(stack) > 1;
            list.add((Component)track.getDisplayName().m_6881_().m_130940_(ChatFormatting.GRAY));
            SoundSourceManager.getBrandText(track.url()).map(component -> Component.m_237113_((String)"  ").m_7220_((Component)component.m_6881_())).map(component -> album ? component.m_130946_(" ").m_7220_(ALBUM) : component).ifPresentOrElse(list::add, () -> {
                if (album) {
                    list.add(ALBUM);
                }
            });
        });
    }

    @Override
    public CompletableFuture<AlbumCover> getAlbumCover(ItemStack stack, Proxy proxy, ResourceManager resourceManager) {
        return this.getAlbum(stack).map(data -> SoundSourceManager.resolveAlbumCover(data.url(), null, proxy, resourceManager)).orElseGet(() -> CompletableFuture.completedFuture(AlbumCover.EMPTY));
    }
}

