/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.api.record;

import gg.moonflower.etched.api.record.AlbumCover;
import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.api.sound.SoundTracker;
import gg.moonflower.etched.common.network.EtchedMessages;
import gg.moonflower.etched.common.network.play.ClientboundPlayEntityMusicPacket;
import java.net.Proxy;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public interface PlayableRecord {
    public static boolean isPlayableRecord(ItemStack stack) {
        return stack.m_41720_() instanceof PlayableRecord && ((PlayableRecord)stack.m_41720_()).canPlay(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean canShowMessage(double x, double y, double z) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        return player == null || player.m_20275_(x, y, z) <= 4096.0;
    }

    public static void playEntityRecord(Entity entity, ItemStack record, boolean restart) {
        EtchedMessages.PLAY.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new ClientboundPlayEntityMusicPacket(record, entity, restart));
    }

    public static void stopEntityRecord(Entity entity) {
        EtchedMessages.PLAY.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new ClientboundPlayEntityMusicPacket(entity));
    }

    public static Optional<TrackData[]> getStackMusic(ItemStack stack) {
        Item item;
        if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof PlayableRecord)) {
            return Optional.empty();
        }
        PlayableRecord record = (PlayableRecord)item;
        return record.getMusic(stack);
    }

    public static Optional<TrackData> getStackAlbum(ItemStack stack) {
        Item item;
        if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof PlayableRecord)) {
            return Optional.empty();
        }
        PlayableRecord record = (PlayableRecord)item;
        return record.getAlbum(stack);
    }

    public static int getStackTrackCount(ItemStack stack) {
        Item item;
        if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof PlayableRecord)) {
            return 0;
        }
        PlayableRecord record = (PlayableRecord)item;
        return record.getTrackCount(stack);
    }

    default public boolean canPlay(ItemStack stack) {
        return this.getMusic(stack).isPresent();
    }

    @OnlyIn(value=Dist.CLIENT)
    default public Optional<? extends SoundInstance> createEntitySound(ItemStack stack, Entity entity, int track, int attenuationDistance) {
        return track < 0 ? Optional.empty() : this.getMusic(stack).filter(tracks -> track < ((TrackData[])tracks).length).map(tracks -> SoundTracker.getEtchedRecord(tracks[track].url(), tracks[track].getDisplayName(), entity, attenuationDistance, false));
    }

    @OnlyIn(value=Dist.CLIENT)
    default public Optional<? extends SoundInstance> createEntitySound(ItemStack stack, Entity entity, int track) {
        return this.createEntitySound(stack, entity, track, 16);
    }

    @OnlyIn(value=Dist.CLIENT)
    public CompletableFuture<AlbumCover> getAlbumCover(ItemStack var1, Proxy var2, ResourceManager var3);

    public Optional<TrackData[]> getMusic(ItemStack var1);

    public Optional<TrackData> getAlbum(ItemStack var1);

    public int getTrackCount(ItemStack var1);
}

