/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.entities.nonliving.vanilla;

import java.util.Objects;
import net.liopyu.entityjs.builders.nonliving.BaseEntityBuilder;
import net.liopyu.entityjs.builders.nonliving.vanilla.TridentJSBuilder;
import net.liopyu.entityjs.entities.nonliving.entityjs.IAnimatableJSNL;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;

public class TridentEntityJS
extends ThrownTrident
implements IAnimatableJSNL {
    public TridentJSBuilder builder;
    private final AnimatableInstanceCache getAnimatableInstanceCache;

    public TridentEntityJS(TridentJSBuilder builder, EntityType<? extends TridentEntityJS> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.builder = builder;
        this.getAnimatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    }

    public TridentEntityJS(TridentJSBuilder builder, EntityType<? extends TridentEntityJS> pEntityType, LivingEntity pShooter, Level pLevel, ItemStack pItemStack) {
        super(pEntityType, pLevel);
        this.builder = builder;
        this.getAnimatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
        this.m_6034_(pShooter.m_20185_(), pShooter.m_20188_() - (double)0.1f, pShooter.m_20189_());
        this.m_5602_((Entity)pShooter);
        if (pShooter instanceof Player) {
            this.f_36705_ = AbstractArrow.Pickup.ALLOWED;
        }
        this.f_37555_ = pItemStack.m_41777_();
        this.f_19804_.m_135381_(f_37558_, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)pItemStack)));
        this.f_19804_.m_135381_(f_37554_, (Object)pItemStack.m_41790_());
    }

    @Override
    public BaseEntityBuilder<?> getBuilder() {
        return this.builder;
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.getAnimatableInstanceCache;
    }

    public String entityName() {
        return this.m_6095_().toString();
    }

    public ItemStack getTridentItem() {
        return this.f_37555_;
    }

    public void setTridentItem(ItemStack tridentItem) {
        this.f_37555_ = tridentItem;
    }

    public boolean m_150194_() {
        if (this.builder != null && this.builder.isChanneling != null) {
            Object obj = this.builder.isChanneling.apply(this);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isChanneling from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_150194_());
        }
        return EnchantmentHelper.m_44936_((ItemStack)this.f_37555_);
    }

    protected SoundEvent m_7239_() {
        return this.builder == null ? super.m_7239_() : this.builder.defaultHitGroundSoundEvent;
    }

    protected void m_5790_(EntityHitResult result) {
        SoundEvent $$6;
        if (this.builder != null && this.builder.onHitEntity != null) {
            ContextUtils.ProjectileEntityHitContext context = new ContextUtils.ProjectileEntityHitContext(result, (Projectile)this);
            EntityJSHelperClass.consumerCallback(this.builder.onHitEntity, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onHitEntity.");
        }
        Entity $$1 = result.m_82443_();
        float $$2 = 8.0f;
        if ($$1 instanceof LivingEntity) {
            LivingEntity $$3 = (LivingEntity)$$1;
            $$2 += EnchantmentHelper.m_44833_((ItemStack)this.f_37555_, (MobType)$$3.m_6336_());
        }
        Entity $$4 = this.m_19749_();
        DamageSource $$5 = this.builder.damageSource != null ? this.builder.damageSource : this.m_269291_().m_269525_((Entity)this, (Entity)($$4 == null ? this : $$4));
        this.f_37556_ = true;
        SoundEvent soundEvent = $$6 = this.builder == null ? SoundEvents.f_12514_ : this.builder.defaultTridentHitSound;
        if ($$1.m_6469_($$5, $$2)) {
            if ($$1.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if ($$1 instanceof LivingEntity) {
                LivingEntity $$7 = (LivingEntity)$$1;
                if ($$4 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)$$7, (Entity)$$4);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)$$4), (Entity)$$7);
                }
                this.m_7761_($$7);
            }
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        float $$8 = 1.0f;
        if (this.m_9236_() instanceof ServerLevel && (this.m_9236_().m_46470_() || this.builder.alwaysThunder) && this.m_150194_()) {
            BlockPos $$9 = $$1.m_20183_();
            if (this.m_9236_().m_45527_($$9)) {
                LightningBolt $$10 = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_());
                $$10.m_20219_(Vec3.m_82539_((Vec3i)$$9));
                $$10.m_20879_($$4 instanceof ServerPlayer ? (ServerPlayer)$$4 : null);
                this.m_9236_().m_7967_((Entity)$$10);
                $$6 = this.builder == null ? SoundEvents.f_12514_ : this.builder.thunderHitSound;
                $$8 = this.builder == null ? 5.0f : this.builder.thunderHitVolume;
            }
        }
        this.m_5496_($$6, $$8, 1.0f);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.builder != null && this.builder.onHurt != null) {
            ContextUtils.EntityHurtContext context = new ContextUtils.EntityHurtContext((Entity)this, pSource, pAmount);
            EntityJSHelperClass.consumerCallback(this.builder.onHurt, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onHurt.");
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        super.m_6453_(x, y, z, yaw, pitch, posRotationIncrements, teleport);
        if (this.builder != null && this.builder.lerpTo != null) {
            ContextUtils.LerpToContext context = new ContextUtils.LerpToContext(x, y, z, yaw, pitch, posRotationIncrements, teleport, (Entity)this);
            EntityJSHelperClass.consumerCallback(this.builder.lerpTo, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: lerpTo.");
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.builder != null && this.builder.tick != null) {
            EntityJSHelperClass.consumerCallback(this.builder.tick, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: tick.");
        }
    }

    public void m_6478_(MoverType pType, Vec3 pPos) {
        super.m_6478_(pType, pPos);
        if (this.builder != null && this.builder.move != null) {
            ContextUtils.MovementContext context = new ContextUtils.MovementContext(pType, pPos, (Entity)this);
            EntityJSHelperClass.consumerCallback(this.builder.move, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: move.");
        }
    }

    public void m_6123_(Player player) {
        if (this.builder != null && this.builder.playerTouch != null) {
            ContextUtils.EntityPlayerContext context = new ContextUtils.EntityPlayerContext(player, (Entity)this);
            EntityJSHelperClass.consumerCallback(this.builder.playerTouch, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: playerTouch.");
        } else {
            super.m_6123_(player);
        }
    }

    public void onRemovedFromWorld() {
        if (this.builder != null && this.builder.onRemovedFromWorld != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onRemovedFromWorld, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onRemovedFromWorld.");
        }
        super.onRemovedFromWorld();
    }

    public void m_8038_(ServerLevel p_19927_, LightningBolt p_19928_) {
        if (this.builder != null && this.builder.thunderHit != null) {
            super.m_8038_(p_19927_, p_19928_);
            ContextUtils.EThunderHitContext context = new ContextUtils.EThunderHitContext(p_19927_, p_19928_, (Entity)this);
            EntityJSHelperClass.consumerCallback(this.builder.thunderHit, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: thunderHit.");
        }
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        if (this.builder != null && this.builder.onFall != null) {
            ContextUtils.EEntityFallDamageContext context = new ContextUtils.EEntityFallDamageContext((Entity)this, pMultiplier, pFallDistance, pSource);
            EntityJSHelperClass.consumerCallback(this.builder.onFall, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onLivingFall.");
        }
        return super.m_142535_(pFallDistance, pMultiplier, pSource);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.builder != null && this.builder.onAddedToWorld != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onAddedToWorld, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onAddedToWorld.");
        }
    }

    public void m_6858_(boolean sprinting) {
        if (this.builder != null && this.builder.onSprint != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onSprint, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onSprint.");
        }
        super.m_6858_(sprinting);
    }

    public void m_8127_() {
        super.m_8127_();
        if (this.builder != null && this.builder.onStopRiding != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onStopRiding, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onStopRiding.");
        }
    }

    public void m_6083_() {
        super.m_6083_();
        if (this.builder != null && this.builder.rideTick != null) {
            EntityJSHelperClass.consumerCallback(this.builder.rideTick, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: rideTick.");
        }
    }

    public void m_142036_() {
        if (this.builder != null && this.builder.onClientRemoval != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onClientRemoval, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onClientRemoval.");
        }
        super.m_142036_();
    }

    public void m_20093_() {
        if (this.builder != null && this.builder.lavaHurt != null) {
            EntityJSHelperClass.consumerCallback(this.builder.lavaHurt, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: lavaHurt.");
        }
        super.m_20093_();
    }

    protected void m_142043_() {
        if (this.builder != null && this.builder.onFlap != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onFlap, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onFlap.");
        }
        super.m_142043_();
    }

    public boolean m_6783_(double distance) {
        if (this.builder.shouldRenderAtSqrDistance != null) {
            ContextUtils.EntitySqrDistanceContext context = new ContextUtils.EntitySqrDistanceContext(distance, (Entity)this);
            Object obj = this.builder.shouldRenderAtSqrDistance.apply(context);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid shouldRenderAtSqrDistance for builder: " + obj + ". Must be a boolean. Defaulting to super method: " + super.m_6783_(distance));
        }
        return super.m_6783_(distance);
    }

    public boolean m_6097_() {
        return this.builder.isAttackable != null ? this.builder.isAttackable.booleanValue() : super.m_6097_();
    }

    public boolean m_6094_() {
        return true;
    }

    public void m_7334_(Entity pEntity) {
        if (this.builder.onEntityCollision != null) {
            ContextUtils.CollidingProjectileEntityContext context = new ContextUtils.CollidingProjectileEntityContext((Entity)this, pEntity);
            EntityJSHelperClass.consumerCallback(this.builder.onEntityCollision, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onEntityCollision.");
        }
        if (this.builder.isPushable) {
            super.m_7334_(pEntity);
        }
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        if (this.builder != null && this.builder.onHitBlock != null) {
            ContextUtils.ProjectileBlockHitContext context = new ContextUtils.ProjectileBlockHitContext(result, (Projectile)this);
            EntityJSHelperClass.consumerCallback(this.builder.onHitBlock, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onHitBlock.");
        }
    }

    protected boolean m_5603_(Entity entity) {
        if (this.builder != null && this.builder.canHitEntity != null) {
            Object obj = this.builder.canHitEntity.apply(entity);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return super.m_5603_(entity) && b != false;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid canHitEntity for arrow builder: " + obj + ". Must be a boolean. Defaulting to super method: " + super.m_5603_(entity));
        }
        return super.m_5603_(entity);
    }

    public LivingEntity m_6688_() {
        LivingEntity entity;
        Entity var2 = this.m_146895_();
        LivingEntity var10000 = var2 instanceof LivingEntity ? (entity = (LivingEntity)var2) : null;
        return var10000;
    }

    public boolean m_7337_(Entity pEntity) {
        if (this.builder.canCollideWith != null) {
            ContextUtils.ECollidingEntityContext context = new ContextUtils.ECollidingEntityContext((Entity)this, pEntity);
            Object obj = this.builder.canCollideWith.apply(context);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canCollideWith from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_7337_(pEntity));
        }
        return super.m_7337_(pEntity);
    }

    protected float m_20098_() {
        if (this.builder.setBlockJumpFactor == null) {
            return super.m_20098_();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setBlockJumpFactor.apply(this), "float");
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setBlockJumpFactor from entity: " + this.entityName() + ". Value: " + this.builder.setBlockJumpFactor.apply(this) + ". Must be a float. Defaulting to " + super.m_20098_());
        return super.m_20098_();
    }

    protected float m_6041_() {
        if (this.builder.blockSpeedFactor == null) {
            return super.m_6041_();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.blockSpeedFactor.apply(this), "float");
        if (this.builder.blockSpeedFactor == null) {
            return super.m_6041_();
        }
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for blockSpeedFactor from entity: " + this.entityName() + ". Value: " + this.builder.blockSpeedFactor.apply(this) + ". Must be a float, defaulting to " + super.m_6041_());
        return super.m_6041_();
    }

    protected void m_19956_(Entity pPassenger, Entity.MoveFunction pCallback) {
        if (this.builder.positionRider != null) {
            ContextUtils.PositionRiderContext context = new ContextUtils.PositionRiderContext((Entity)this, pPassenger, pCallback);
            EntityJSHelperClass.consumerCallback(this.builder.positionRider, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: positionRider.");
            return;
        }
        super.m_19956_(pPassenger, pCallback);
    }

    protected boolean m_7310_(@NotNull Entity entity) {
        if (this.builder.canAddPassenger == null) {
            return super.m_7310_(entity);
        }
        ContextUtils.EPassengerEntityContext context = new ContextUtils.EPassengerEntityContext(entity, (Entity)this);
        Object obj = this.builder.canAddPassenger.apply(context);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canAddPassenger from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean, defaulting to " + super.m_7310_(entity));
        return super.m_7310_(entity);
    }

    protected boolean m_142039_() {
        if (this.builder.isFlapping != null) {
            Object obj = this.builder.isFlapping.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isFlapping from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_142039_());
        }
        return super.m_142039_();
    }

    protected boolean m_6093_() {
        return Objects.requireNonNullElseGet(this.builder.repositionEntityAfterLoad, () -> super.m_6093_());
    }

    protected float m_6059_() {
        if (this.builder.nextStep != null) {
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.nextStep.apply(this), "float");
            if (obj != null) {
                return ((Float)obj).floatValue();
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for nextStep from entity: " + this.entityName() + ". Value: " + this.builder.nextStep.apply(this) + ". Must be a float, defaulting to " + super.m_6059_());
        }
        return super.m_6059_();
    }

    protected SoundEvent m_5509_() {
        if (this.builder.setSwimSplashSound == null) {
            return super.m_5509_();
        }
        return Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue((ResourceLocation)this.builder.setSwimSplashSound));
    }

    protected SoundEvent m_5501_() {
        if (this.builder.setSwimSound == null) {
            return super.m_5501_();
        }
        return Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue((ResourceLocation)this.builder.setSwimSound));
    }

    public boolean m_142079_() {
        if (this.builder.canFreeze != null) {
            Object obj = this.builder.canFreeze.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canFreeze from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_142079_());
        }
        return super.m_142079_();
    }

    public boolean m_203117_() {
        if (this.builder.isFreezing != null) {
            Object obj = this.builder.isFreezing.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isFreezing from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_203117_());
        }
        return super.m_203117_();
    }

    public boolean m_142038_() {
        if (this.builder.isCurrentlyGlowing != null) {
            Object obj = this.builder.isCurrentlyGlowing.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isCurrentlyGlowing from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_142038_());
        }
        return super.m_142038_();
    }

    public boolean m_213854_() {
        if (this.builder.dampensVibrations != null) {
            Object obj = this.builder.dampensVibrations.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for dampensVibrations from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_213854_());
        }
        return super.m_213854_();
    }

    public boolean m_20152_() {
        if (this.builder.showVehicleHealth != null) {
            Object obj = this.builder.showVehicleHealth.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for showVehicleHealth from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_20152_());
        }
        return super.m_20152_();
    }

    public boolean m_6673_(DamageSource p_20122_) {
        if (this.builder.isInvulnerableTo != null) {
            ContextUtils.EDamageContext context = new ContextUtils.EDamageContext((Entity)this, p_20122_);
            Object obj = this.builder.isInvulnerableTo.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isInvulnerableTo from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_6673_(p_20122_));
        }
        return super.m_6673_(p_20122_);
    }

    public boolean m_6072_() {
        if (this.builder.canChangeDimensions != null) {
            Object obj = this.builder.canChangeDimensions.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canChangeDimensions from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_6072_());
        }
        return super.m_6072_();
    }

    public boolean m_142265_(@NotNull Level p_146843_, @NotNull BlockPos p_146844_) {
        if (this.builder.mayInteract != null) {
            ContextUtils.EMayInteractContext context = new ContextUtils.EMayInteractContext(p_146843_, p_146844_, (Entity)this);
            Object obj = this.builder.mayInteract.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for mayInteract from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_142265_(p_146843_, p_146844_));
        }
        return super.m_142265_(p_146843_, p_146844_);
    }

    public boolean canTrample(@NotNull BlockState state, @NotNull BlockPos pos, float fallDistance) {
        if (this.builder.canTrample != null) {
            ContextUtils.ECanTrampleContext context = new ContextUtils.ECanTrampleContext(state, pos, fallDistance, (Entity)this);
            Object obj = this.builder.canTrample.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canTrample from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.canTrample(state, pos, fallDistance));
        }
        return super.canTrample(state, pos, fallDistance);
    }

    public boolean m_5829_() {
        if (this.builder.canBeCollidedWith == null) {
            return super.m_5829_();
        }
        Object obj = this.builder.canBeCollidedWith.apply(this);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canBeCollidedWith from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_5829_());
        return super.m_5829_();
    }

    public int m_6056_() {
        if (this.builder.setMaxFallDistance == null) {
            return super.m_6056_();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setMaxFallDistance.apply(this), "integer");
        if (obj != null) {
            return (Integer)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setMaxFallDistance from entity: " + this.entityName() + ". Value: " + this.builder.setMaxFallDistance.apply(this) + ". Must be an integer. Defaulting to " + super.m_6056_());
        return super.m_6056_();
    }
}

