/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.data;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.emi.emi.EmiPort;
import dev.emi.emi.bom.BoM;
import dev.emi.emi.data.EmiResourceReloadListener;
import dev.emi.emi.data.RecipeDefaults;
import dev.emi.emi.runtime.EmiLog;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;

public class RecipeDefaultLoader
extends SimplePreparableReloadListener<RecipeDefaults>
implements EmiResourceReloadListener {
    private static final Gson GSON = new Gson();
    public static final ResourceLocation ID = EmiPort.id("emi:recipe_defaults");

    protected RecipeDefaults prepare(ResourceManager manager, ProfilerFiller profiler) {
        RecipeDefaults defaults = new RecipeDefaults();
        for (ResourceLocation id : EmiPort.findResources(manager, "recipe/defaults", i -> i.endsWith(".json"))) {
            if (!id.m_135827_().equals("emi")) continue;
            try {
                for (Resource resource : manager.m_213829_(id)) {
                    InputStreamReader reader = new InputStreamReader(EmiPort.getInputStream(resource));
                    JsonObject json = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
                    RecipeDefaultLoader.loadDefaults(defaults, json);
                }
            }
            catch (Exception e) {
                EmiLog.error("Error loading recipe default file " + String.valueOf(id), e);
            }
        }
        return defaults;
    }

    protected void apply(RecipeDefaults prepared, ResourceManager manager, ProfilerFiller profiler) {
        BoM.setDefaults(prepared);
    }

    @Override
    public ResourceLocation getEmiId() {
        return ID;
    }

    public static void loadDefaults(RecipeDefaults defaults, JsonObject json) {
        if (GsonHelper.m_13855_((JsonObject)json, (String)"replace", (boolean)false)) {
            defaults.clear();
        }
        JsonArray disabled = GsonHelper.m_13832_((JsonObject)json, (String)"disabled", (JsonArray)new JsonArray());
        for (Object el : disabled) {
            ResourceLocation id = EmiPort.id(el.getAsString());
            defaults.remove(id);
        }
        JsonArray added = GsonHelper.m_13832_((JsonObject)json, (String)"added", (JsonArray)new JsonArray());
        if (GsonHelper.m_13885_((JsonObject)json, (String)"recipes")) {
            added.addAll(GsonHelper.m_13933_((JsonObject)json, (String)"recipes"));
        }
        for (Object el : added) {
            ResourceLocation id = EmiPort.id(el.getAsString());
            defaults.add(id);
        }
        JsonObject resolutions = GsonHelper.m_13841_((JsonObject)json, (String)"resolutions", (JsonObject)new JsonObject());
        for (String key : resolutions.keySet()) {
            ResourceLocation id = EmiPort.id(key);
            if (!GsonHelper.m_13885_((JsonObject)resolutions, (String)key)) continue;
            defaults.add(id, GsonHelper.m_13933_((JsonObject)resolutions, (String)key));
        }
        JsonObject addedTags = GsonHelper.m_13841_((JsonObject)json, (String)"tags", (JsonObject)new JsonObject());
        for (String key : addedTags.keySet()) {
            defaults.addTag((JsonElement)new JsonPrimitive(key), addedTags.get(key));
        }
    }
}

