/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.emberstextapi.immersivemessages.util;

public class ImmersiveColor {
    private int argb;
    public static final ImmersiveColor WHITE = new ImmersiveColor(-1);
    public static final ImmersiveColor BLACK = new ImmersiveColor(-16777216);

    public ImmersiveColor(int argb) {
        this.argb = argb;
    }

    public ImmersiveColor(int r, int g, int b, int a) {
        this.argb = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public int getARGB() {
        return this.argb;
    }

    public int getRGB() {
        return this.argb & 0xFFFFFF;
    }

    public ImmersiveColor mixWith(ImmersiveColor other, float amount) {
        int r = (int)((float)this.getRed() * (1.0f - amount) + (float)other.getRed() * amount);
        int g = (int)((float)this.getGreen() * (1.0f - amount) + (float)other.getGreen() * amount);
        int b = (int)((float)this.getBlue() * (1.0f - amount) + (float)other.getBlue() * amount);
        int a = (int)((float)this.getAlpha() * (1.0f - amount) + (float)other.getAlpha() * amount);
        return new ImmersiveColor(r, g, b, a);
    }

    public ImmersiveColor copy() {
        return new ImmersiveColor(this.argb);
    }

    public int getRed() {
        return this.argb >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.argb >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.argb & 0xFF;
    }

    public int getAlpha() {
        return this.argb >> 24 & 0xFF;
    }
}

