/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.emberstextapi.immersivemessages.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;

@OnlyIn(value=Dist.CLIENT)
public final class CaxtonCompat {
    private static final String MOD_ID = "caxton";
    private static final String RENDERER_CLASS = "xyz.flirora.caxton.render.CaxtonTextRenderer";
    private static final String HANDLER_METHOD = "getHandler";
    private static final String WIDTH_METHOD = "getWidth";
    private static final String HANDLER_CLASS = "xyz.flirora.caxton.layout.CaxtonTextHandler";
    private static volatile WidthProvider cachedHandler;
    private static volatile boolean attemptedLoad;

    private CaxtonCompat() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WidthProvider getHandler() {
        if (!ModList.get().isLoaded(MOD_ID)) {
            return null;
        }
        WidthProvider handler = cachedHandler;
        if (handler != null || attemptedLoad) {
            return handler;
        }
        Class<CaxtonCompat> clazz = CaxtonCompat.class;
        synchronized (CaxtonCompat.class) {
            if (cachedHandler != null || attemptedLoad) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return cachedHandler;
            }
            cachedHandler = CaxtonCompat.loadHandler();
            attemptedLoad = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cachedHandler;
        }
    }

    private static WidthProvider loadHandler() {
        try {
            Class<?> rendererClass = Class.forName(RENDERER_CLASS);
            Method getInstance = rendererClass.getDeclaredMethod("getInstance", new Class[0]);
            Object renderer = getInstance.invoke(null, new Object[0]);
            Method getHandler = rendererClass.getDeclaredMethod(HANDLER_METHOD, new Class[0]);
            Object handlerInstance = getHandler.invoke(renderer, new Object[0]);
            if (handlerInstance == null) {
                return null;
            }
            Class<?> handlerClass = Class.forName(HANDLER_CLASS);
            Method width = handlerClass.getMethod(WIDTH_METHOD, FormattedCharSequence.class);
            return sequence -> CaxtonCompat.invokeWidth(handlerInstance, width, sequence);
        }
        catch (ClassNotFoundException | IllegalAccessException | LinkageError | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    private static float invokeWidth(Object handler, Method width, FormattedCharSequence sequence) {
        try {
            Object result = width.invoke(handler, sequence);
            if (result instanceof Number) {
                Number number = (Number)result;
                return number.floatValue();
            }
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return Float.NaN;
    }

    @OnlyIn(value=Dist.CLIENT)
    @FunctionalInterface
    public static interface WidthProvider {
        public float getWidth(FormattedCharSequence var1);
    }
}

