/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.emberstextapi.immersivemessages;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tysontheember.emberstextapi.EmbersTextAPI;
import net.tysontheember.emberstextapi.immersivemessages.api.ImmersiveMessage;
import net.tysontheember.emberstextapi.immersivemessages.api.ObfuscateMode;
import net.tysontheember.emberstextapi.immersivemessages.api.ShakeType;
import net.tysontheember.emberstextapi.immersivemessages.api.TextAnchor;
import net.tysontheember.emberstextapi.immersivemessages.util.ImmersiveColor;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="emberstextapi")
public class MessageCommands {
    private static final Logger LOGGER = LogUtils.getLogger();

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"emberstextapi").then(MessageCommands.testSubcommand())).then(MessageCommands.sendSubcommand())).then(MessageCommands.customSubcommand()));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> testSubcommand() {
        return Commands.m_82127_((String)"test").then(Commands.m_82129_((String)"id", (ArgumentType)IntegerArgumentType.integer((int)1, (int)9)).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            int id = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"id");
            MessageCommands.runTest(player, id);
            return 1;
        }));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> sendSubcommand() {
        return Commands.m_82127_((String)"send").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"duration", (ArgumentType)FloatArgumentType.floatArg()).then(Commands.m_82129_((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            ServerPlayer target = EntityArgument.m_91474_((CommandContext)ctx, (String)"player");
            float duration = FloatArgumentType.getFloat((CommandContext)ctx, (String)"duration");
            String text = StringArgumentType.getString((CommandContext)ctx, (String)"text");
            EmbersTextAPI.sendMessage(target, ImmersiveMessage.builder(duration, text));
            return 1;
        }))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> customSubcommand() {
        return Commands.m_82127_((String)"sendcustom").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"data", (ArgumentType)CompoundTagArgument.m_87657_()).then(Commands.m_82129_((String)"duration", (ArgumentType)FloatArgumentType.floatArg()).then(Commands.m_82129_((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            ImmersiveColor border;
            ImmersiveColor start;
            CompoundTag grad;
            Object c;
            int i;
            ArrayList<Object> cols;
            ListTag list;
            ResourceLocation font;
            ServerPlayer target = EntityArgument.m_91474_((CommandContext)ctx, (String)"player");
            CompoundTag tag = CompoundTagArgument.m_87660_((CommandContext)ctx, (String)"data");
            float duration = FloatArgumentType.getFloat((CommandContext)ctx, (String)"duration");
            String text = StringArgumentType.getString((CommandContext)ctx, (String)"text");
            HashMap<String, String> keys = new HashMap<String, String>();
            for (String k : tag.m_128431_()) {
                keys.put(k.toLowerCase(Locale.ROOT), k);
            }
            MutableComponent component = Component.m_237113_((String)text);
            if (tag.m_128441_("font") && (font = ResourceLocation.m_135820_((String)tag.m_128461_("font"))) != null) {
                component = component.m_130938_(style -> style.m_131150_(font));
            }
            if (tag.m_128441_("bold") && tag.m_128471_("bold")) {
                component = component.m_130938_(style -> style.m_131136_(Boolean.valueOf(true)));
            }
            if (tag.m_128441_("italic") && tag.m_128471_("italic")) {
                component = component.m_130938_(style -> style.m_131155_(Boolean.valueOf(true)));
            }
            if (tag.m_128441_("underlined") && tag.m_128471_("underlined")) {
                component = component.m_130938_(style -> style.m_131162_(Boolean.valueOf(true)));
            }
            if (tag.m_128441_("strikethrough") && tag.m_128471_("strikethrough")) {
                component = component.m_130938_(style -> style.m_178522_(Boolean.valueOf(true)));
            }
            if (tag.m_128441_("obfuscated") && tag.m_128471_("obfuscated")) {
                component = component.m_130938_(style -> style.m_178524_(Boolean.valueOf(true)));
            }
            if (tag.m_128441_("color")) {
                String colour = tag.m_128461_("color");
                ChatFormatting fmt = ChatFormatting.m_126657_((String)colour);
                if (fmt != null) {
                    component = component.m_130938_(style -> style.m_131140_(fmt));
                } else {
                    TextColor parsed = TextColor.m_131268_((String)colour);
                    if (parsed != null) {
                        component = component.m_130938_(style -> style.m_131148_(parsed));
                    }
                }
            }
            ImmersiveMessage msg = new ImmersiveMessage((Component)component, duration);
            if (tag.m_128425_("gradient", 9)) {
                list = tag.m_128437_("gradient", 8);
                cols = new ArrayList<TextColor>();
                for (i = 0; i < list.size(); ++i) {
                    c = MessageCommands.parseColor(list.m_128778_(i));
                    if (c == null) continue;
                    cols.add(c);
                }
                if (cols.size() >= 2) {
                    msg.gradient(cols);
                }
            } else if (tag.m_128425_("gradient", 10)) {
                grad = tag.m_128469_("gradient");
                String startStr = grad.m_128461_("start");
                String endStr = grad.m_128461_("end");
                TextColor start2 = MessageCommands.parseColor(startStr);
                TextColor end = MessageCommands.parseColor(endStr);
                if (start2 != null && end != null) {
                    msg.gradient(start2, end);
                }
            }
            if (tag.m_128425_("bgGradient", 9)) {
                list = tag.m_128437_("bgGradient", 8);
                cols = new ArrayList();
                for (i = 0; i < list.size(); ++i) {
                    c = MessageCommands.parseImmersiveColor(list.m_128778_(i));
                    if (c == null) continue;
                    cols.add(c);
                }
                if (cols.size() >= 2) {
                    msg.background(true);
                    msg.backgroundGradient((ImmersiveColor)cols.get(0), (ImmersiveColor)cols.get(cols.size() - 1));
                }
            } else if (tag.m_128425_("bgGradient", 10)) {
                grad = tag.m_128469_("bgGradient");
                start = MessageCommands.parseImmersiveColor(grad.m_128461_("start"));
                ImmersiveColor end = MessageCommands.parseImmersiveColor(grad.m_128461_("end"));
                if (start != null && end != null) {
                    msg.background(true);
                    msg.backgroundGradient(start, end);
                }
            }
            if (tag.m_128425_("borderGradient", 9)) {
                list = tag.m_128437_("borderGradient", 8);
                cols = new ArrayList();
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    c = MessageCommands.parseImmersiveColor(list.m_128778_(i2));
                    if (c == null) continue;
                    cols.add(c);
                }
                if (cols.size() >= 2) {
                    msg.background(true);
                    msg.borderGradient((ImmersiveColor)cols.get(0), (ImmersiveColor)cols.get(cols.size() - 1));
                }
            } else if (tag.m_128425_("borderGradient", 10)) {
                grad = tag.m_128469_("borderGradient");
                start = MessageCommands.parseImmersiveColor(grad.m_128461_("start"));
                ImmersiveColor end = MessageCommands.parseImmersiveColor(grad.m_128461_("end"));
                if (start != null && end != null) {
                    msg.background(true);
                    msg.borderGradient(start, end);
                }
            }
            if (tag.m_128441_("bgColor")) {
                msg.bgColor(tag.m_128461_("bgColor"));
            }
            if (tag.m_128425_("textureBackground", 8)) {
                ResourceLocation texture = ResourceLocation.m_135820_((String)tag.m_128461_("textureBackground"));
                if (texture != null) {
                    msg.textureBackground(texture);
                }
            } else if (tag.m_128425_("textureBackground", 10)) {
                ResourceLocation texture;
                CompoundTag tex = tag.m_128469_("textureBackground");
                String key = tex.m_128441_("location") ? "location" : (tex.m_128441_("texture") ? "texture" : null);
                ResourceLocation resourceLocation = texture = key != null ? ResourceLocation.m_135820_((String)tex.m_128461_(key)) : null;
                if (texture != null) {
                    int u = tex.m_128441_("u") ? tex.m_128451_("u") : 0;
                    int v = tex.m_128441_("v") ? tex.m_128451_("v") : 0;
                    int regionWidth = tex.m_128441_("width") ? tex.m_128451_("width") : 256;
                    int regionHeight = tex.m_128441_("height") ? tex.m_128451_("height") : 256;
                    int atlasWidth = tex.m_128441_("atlasWidth") ? tex.m_128451_("atlasWidth") : regionWidth;
                    int atlasHeight = tex.m_128441_("atlasHeight") ? tex.m_128451_("atlasHeight") : regionHeight;
                    msg.textureBackground(texture, u, v, regionWidth, regionHeight, atlasWidth, atlasHeight);
                    if (tex.m_128441_("padding")) {
                        msg.textureBackgroundPadding(tex.m_128457_("padding"));
                    }
                    if (tex.m_128441_("paddingX") || tex.m_128441_("paddingY")) {
                        float padX = tex.m_128441_("paddingX") ? tex.m_128457_("paddingX") : Float.NaN;
                        float padY = tex.m_128441_("paddingY") ? tex.m_128457_("paddingY") : Float.NaN;
                        msg.textureBackgroundPadding(padX, padY);
                    }
                    if (tex.m_128441_("scale")) {
                        msg.textureBackgroundScale(tex.m_128457_("scale"));
                    }
                    if (tex.m_128441_("scaleX") || tex.m_128441_("scaleY")) {
                        float scaleX = tex.m_128441_("scaleX") ? tex.m_128457_("scaleX") : Float.NaN;
                        float scaleY = tex.m_128441_("scaleY") ? tex.m_128457_("scaleY") : Float.NaN;
                        msg.textureBackgroundScale(scaleX, scaleY);
                    }
                    if (tex.m_128441_("size")) {
                        float size = tex.m_128457_("size");
                        msg.textureBackgroundSize(size, size);
                    }
                    if (tex.m_128441_("sizeX")) {
                        msg.textureBackgroundWidth(tex.m_128457_("sizeX"));
                    }
                    if (tex.m_128441_("sizeY")) {
                        msg.textureBackgroundHeight(tex.m_128457_("sizeY"));
                    }
                    if (tex.m_128441_("drawWidth")) {
                        msg.textureBackgroundWidth(tex.m_128457_("drawWidth"));
                    }
                    if (tex.m_128441_("drawHeight")) {
                        msg.textureBackgroundHeight(tex.m_128457_("drawHeight"));
                    }
                    if (tex.m_128441_("x")) {
                        msg.textureBackgroundWidth(tex.m_128457_("x"));
                    }
                    if (tex.m_128441_("y")) {
                        msg.textureBackgroundHeight(tex.m_128457_("y"));
                    }
                    if (tex.m_128441_("resize")) {
                        msg.textureBackgroundMode(tex.m_128471_("resize") ? ImmersiveMessage.TextureSizingMode.STRETCH : ImmersiveMessage.TextureSizingMode.CROP);
                    }
                    if (tex.m_128441_("cut") && tex.m_128471_("cut")) {
                        msg.textureBackgroundMode(ImmersiveMessage.TextureSizingMode.CROP);
                    }
                    if (tex.m_128441_("mode")) {
                        msg.textureBackgroundMode(ImmersiveMessage.TextureSizingMode.fromString(tex.m_128461_("mode")));
                    }
                }
            }
            if (tag.m_128441_("borderColor") && (border = MessageCommands.parseImmersiveColor(tag.m_128461_("borderColor"))) != null) {
                msg.background(true);
                msg.borderGradient(border, border);
            }
            if (tag.m_128441_("size")) {
                msg.scale(tag.m_128457_("size"));
            }
            if (tag.m_128441_("typewriter")) {
                float speed = tag.m_128457_("typewriter");
                boolean center = tag.m_128471_("center");
                msg.typewriter(speed, center);
            }
            if (tag.m_128441_("background") && tag.m_128471_("background")) {
                msg.background(true);
            }
            if (tag.m_128441_("bgAlpha")) {
                msg.bgAlpha(tag.m_128457_("bgAlpha"));
            }
            if (tag.m_128441_("wrap")) {
                msg.wrap(tag.m_128451_("wrap"));
            }
            if (tag.m_128441_("obfuscate")) {
                ObfuscateMode mode = ObfuscateMode.valueOf(tag.m_128461_("obfuscate").toUpperCase());
                float speed = tag.m_128441_("obfuscateSpeed") ? tag.m_128457_("obfuscateSpeed") : 1.0f;
                msg.obfuscate(mode, speed);
            }
            if (tag.m_128441_("anchor")) {
                msg.anchor(TextAnchor.valueOf(tag.m_128461_("anchor").toUpperCase()));
            }
            if (tag.m_128441_("align")) {
                msg.align(TextAnchor.valueOf(tag.m_128461_("align").toUpperCase()));
            }
            if (tag.m_128441_("offsetX") || tag.m_128441_("offsetY")) {
                float x = tag.m_128441_("offsetX") ? tag.m_128457_("offsetX") : 0.0f;
                float y = tag.m_128441_("offsetY") ? tag.m_128457_("offsetY") : 0.0f;
                msg.offset(x, y);
            }
            if (tag.m_128441_("shadow")) {
                msg.shadow(tag.m_128471_("shadow"));
            }
            if (keys.containsKey("shakewave")) {
                msg.shake(ShakeType.WAVE, tag.m_128457_((String)keys.get("shakewave")));
            } else if (keys.containsKey("wave")) {
                LOGGER.warn("Tag 'wave' is deprecated, use 'shakeWave' instead");
                msg.shake(ShakeType.WAVE, tag.m_128457_((String)keys.get("wave")));
            } else if (keys.containsKey("shakecircle")) {
                msg.shake(ShakeType.CIRCLE, tag.m_128457_((String)keys.get("shakecircle")));
            } else if (keys.containsKey("circle")) {
                LOGGER.warn("Tag 'circle' is deprecated, use 'shakeCircle' instead");
                msg.shake(ShakeType.CIRCLE, tag.m_128457_((String)keys.get("circle")));
            } else if (keys.containsKey("shakerandom")) {
                msg.shake(ShakeType.RANDOM, tag.m_128457_((String)keys.get("shakerandom")));
            } else if (keys.containsKey("random")) {
                LOGGER.warn("Tag 'random' is deprecated, use 'shakeRandom' instead");
                msg.shake(ShakeType.RANDOM, tag.m_128457_((String)keys.get("random")));
            }
            if (keys.containsKey("charshakewave")) {
                msg.charShake(ShakeType.WAVE, tag.m_128457_((String)keys.get("charshakewave")));
            } else if (keys.containsKey("wavechar")) {
                LOGGER.warn("Tag 'waveChar' is deprecated, use 'charShakeWave' instead");
                msg.charShake(ShakeType.WAVE, tag.m_128457_((String)keys.get("wavechar")));
            } else if (keys.containsKey("charshakecircle")) {
                msg.charShake(ShakeType.CIRCLE, tag.m_128457_((String)keys.get("charshakecircle")));
            } else if (keys.containsKey("circlechar")) {
                LOGGER.warn("Tag 'circleChar' is deprecated, use 'charShakeCircle' instead");
                msg.charShake(ShakeType.CIRCLE, tag.m_128457_((String)keys.get("circlechar")));
            } else if (keys.containsKey("charshakerandom")) {
                msg.charShake(ShakeType.RANDOM, tag.m_128457_((String)keys.get("charshakerandom")));
            } else if (keys.containsKey("randomchar")) {
                LOGGER.warn("Tag 'randomChar' is deprecated, use 'charShakeRandom' instead");
                msg.charShake(ShakeType.RANDOM, tag.m_128457_((String)keys.get("randomchar")));
            }
            EmbersTextAPI.sendMessage(target, msg);
            return 1;
        })))));
    }

    private static void runTest(ServerPlayer player, int id) {
        switch (id) {
            case 1: {
                EmbersTextAPI.sendMessage(player, ImmersiveMessage.builder(75.0f, "Basic message"));
                break;
            }
            case 2: {
                EmbersTextAPI.sendMessage(player, ImmersiveMessage.builder(100.0f, "Typewriter demo").typewriter(1.0f));
                break;
            }
            case 3: {
                EmbersTextAPI.sendMessage(player, ImmersiveMessage.builder(200.0f, "Secret text").obfuscate(ObfuscateMode.RANDOM, 0.1f));
                break;
            }
            case 4: {
                EmbersTextAPI.sendMessage(player, ImmersiveMessage.builder(100.0f, "Framed text").background(true));
                break;
            }
            case 5: {
                EmbersTextAPI.sendMessage(player, ImmersiveMessage.builder(100.0f, "Wrapped text demo that is quite long").wrap(120));
                break;
            }
            case 6: {
                ResourceLocation font = new ResourceLocation("emberstextapi", "norse");
                MutableComponent text = Component.m_237113_((String)"\u16a0\u16a2\u16a6\u16a8\u16ab\u16b2").m_130938_(s -> s.m_131150_(font));
                EmbersTextAPI.sendMessage(player, new ImmersiveMessage((Component)text, 100.0f));
                break;
            }
            case 7: {
                MutableComponent component = Component.m_237113_((String)"You shall die here...").m_130938_(s -> s.m_131150_(new ResourceLocation("emberstextapi", "norse"))).m_130938_(s -> s.m_131136_(Boolean.valueOf(true)));
                ImmersiveMessage msg = new ImmersiveMessage((Component)component, 250.0f).scale(2.0f).background(true).obfuscate(ObfuscateMode.LEFT, 0.1f).anchor(TextAnchor.CENTER_CENTER).charShake(ShakeType.RANDOM, 0.5f);
                EmbersTextAPI.sendMessage(player, msg);
                break;
            }
            case 8: {
                EmbersTextAPI.sendMessage(player, ImmersiveMessage.builder(100.0f, "Jittery chars").charShake(ShakeType.RANDOM, 0.5f));
                break;
            }
            case 9: {
                EmbersTextAPI.sendMessage(player, ImmersiveMessage.builder(100.0f, "Wavy jitter").shake(ShakeType.WAVE, 0.5f).charShake(ShakeType.RANDOM, 2.0f));
            }
        }
    }

    private static TextColor parseColor(String value) {
        ChatFormatting fmt = ChatFormatting.m_126657_((String)value);
        if (fmt != null) {
            return TextColor.m_131270_((ChatFormatting)fmt);
        }
        return TextColor.m_131268_((String)value);
    }

    private static ImmersiveColor parseImmersiveColor(String value) {
        if (value == null) {
            return null;
        }
        String v = value.trim();
        try {
            if (v.startsWith("#")) {
                v = v.substring(1);
            }
            if (v.startsWith("0x")) {
                v = v.substring(2);
            }
            if (v.length() == 8) {
                return new ImmersiveColor((int)Long.parseLong(v, 16));
            }
            if (v.length() == 6) {
                return new ImmersiveColor(0xFF000000 | Integer.parseInt(v, 16));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        TextColor c = MessageCommands.parseColor(value);
        return c != null ? new ImmersiveColor(0xFF000000 | c.m_131265_()) : null;
    }
}

