/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.emberstextapi.immersivemessages;

import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.tysontheember.emberstextapi.immersivemessages.api.ImmersiveMessage;

public class ImmersiveMessagesManager {
    private static final Queue<ImmersiveMessage> QUEUE = new LinkedList<ImmersiveMessage>();
    private static final float MESSAGE_GAP_TICKS = 20.0f;
    private static ImmersiveMessage current;
    private static float nextDelay;
    private static float currentDelay;

    public static void tick() {
        if (current == null) {
            if (nextDelay > 0.0f && (nextDelay = Math.max(0.0f, nextDelay - 1.0f)) > 0.0f) {
                return;
            }
            current = QUEUE.poll();
            if (current != null) {
                currentDelay = current.getDelay();
            }
        }
        if (current == null) {
            return;
        }
        if (currentDelay > 0.0f && (currentDelay = Math.max(0.0f, currentDelay - 1.0f)) > 0.0f) {
            return;
        }
        current.tick(1.0f);
        if (current.isFinished()) {
            ImmersiveMessagesManager.finishCurrent();
        }
    }

    public static void render(GuiGraphics graphics) {
        if (current != null && currentDelay <= 0.0f) {
            current.render(graphics);
        }
    }

    private static void finishCurrent() {
        current = null;
        nextDelay = 20.0f;
    }

    public static void showToPlayer(LocalPlayer player, ImmersiveMessage message) {
        QUEUE.add(message);
    }

    public static void clear() {
        QUEUE.clear();
        current = null;
        nextDelay = 0.0f;
        currentDelay = 0.0f;
    }
}

