/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.ears.common.mixin;

import com.unascribed.ears.common.debug.EarsLog;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.mixin.Mixins;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.Config;

public class EarsMixinConfigPlugin
implements IMixinConfigPlugin {
    public void onLoad(String mixinPackage) {
        for (Config config : Mixins.getConfigs()) {
            IMixinConfig imc = config.getConfig();
            if (!imc.getMixinPackage().startsWith("dev.tr7zw.firstperson.") && !imc.getMixinPackage().startsWith("de.tr7zw.firstperson.")) continue;
            EarsLog.debug(EarsLog.Tag.COMMON_MIXIN, "Found FirstPersonModel. Scanning...");
            List mixinClassesClient = (List)EarsMixinConfigPlugin.pluck(imc.getClass(), imc, "mixinClassesClient");
            if (mixinClassesClient.remove("DownloadingTextureMixin")) {
                EarsLog.debug(EarsLog.Tag.COMMON_MIXIN, "Suppressing MCP-named skin transparency mixin.");
                continue;
            }
            if (mixinClassesClient.remove("PlayerSkinTextureMixin")) {
                EarsLog.debug(EarsLog.Tag.COMMON_MIXIN, "Suppressing Yarn-named skin transparency mixin.");
                continue;
            }
            EarsLog.debug(EarsLog.Tag.COMMON_MIXIN, "Didn't find any mixins to suppress.");
        }
    }

    private static <T> T pluck(Class<?> clazz, Object inst, String field) {
        Field f = null;
        for (Class<?> cursor = clazz; f == null && cursor != null; cursor = cursor.getSuperclass()) {
            try {
                f = cursor.getDeclaredField(field);
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        if (f == null) {
            throw new NoSuchFieldError(field);
        }
        f.setAccessible(true);
        try {
            return (T)f.get(inst);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

